/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.components.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.TreeMap;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.common.CustomCrypto;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class CryptoTest
extends Assert {
    public CryptoTest() {
        WSSConfig.init();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testCrypto() throws Exception {
        Crypto crypto = CryptoFactory.getInstance();
        CryptoTest.assertTrue((crypto != null ? 1 : 0) != 0);
    }

    @Test
    public void testMerlinWithNullProperties() throws Exception {
        NullPropertiesCrypto crypto = new NullPropertiesCrypto();
        CryptoTest.assertTrue((crypto != null ? 1 : 0) != 0);
    }

    @Test
    public void testCustomCrypto() throws Exception {
        TreeMap tmp = new TreeMap();
        Crypto crypto = CryptoFactory.getInstance(CustomCrypto.class, tmp);
        CryptoTest.assertNotNull((Object)crypto);
        CryptoTest.assertTrue((boolean)(crypto instanceof CustomCrypto));
        CustomCrypto custom = (CustomCrypto)crypto;
        CryptoTest.assertSame(tmp, custom.getConfig());
    }

    @Test
    public void testNoKeyStoreFile() throws Exception {
        Crypto crypto = CryptoFactory.getInstance((String)"nofile.properties");
        CryptoTest.assertNotNull((Object)crypto);
    }

    @Test
    public void testDynamicCrypto() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Merlin crypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(CryptoTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40.jks");
        keyStore.load(input, "security".toCharArray());
        crypto.setKeyStore(keyStore);
        Document signedDoc = builder.build(doc, (Crypto)crypto, secHeader);
        Merlin processCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        processCrypto.setTrustStore(trustStore);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.processSecurityHeader(signedDoc, null, null, (Crypto)processCrypto);
        processCrypto = new Merlin();
        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40badca.jks");
        trustStore.load(input, "security".toCharArray());
        processCrypto.setTrustStore(trustStore);
        try {
            secEngine.processSecurityHeader(signedDoc, null, null, (Crypto)processCrypto);
            CryptoTest.fail((String)"Expected failure on a bad trust store");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    private static class NullPropertiesCrypto
    extends Merlin {
        public NullPropertiesCrypto() throws Exception {
            super(null, null, null);
        }
    }
}

