/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.SecurityTokenReference;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DerivedKeyTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(DerivedKeyTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public DerivedKeyTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testEncryptionDecryptionTRIPLEDES() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.prepare(doc, this.crypto);
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(ek, tokenIdentifier);
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        encrKeyBuilder.prependToHeader(secHeader);
        encrKeyBuilder.prependBSTElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testEncryptionDecryptionAES128() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.prepare(doc, this.crypto);
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(ek, tokenIdentifier);
        Document encryptedDoc = encrBuilder.build(doc, secHeader);
        encrKeyBuilder.prependToHeader(secHeader);
        encrKeyBuilder.prependBSTElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignature() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.prepare(doc, this.crypto);
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(ek, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.build(doc, secHeader);
        encrKeyBuilder.prependToHeader(secHeader);
        encrKeyBuilder.prependBSTElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        DerivedKeyTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(doc), (int)2)) != null ? 1 : 0) != 0);
        DerivedKeyTest.assertFalse((boolean)actionResult.isEmpty());
        DerivedKeyTest.assertTrue((actionResult.get((Object)"secret") != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureThumbprintSHA1() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        secToken.setKeyIdentifierThumb(certs[0]);
        WSSecDKSign sigBuilder = new WSSecDKSign();
        PrivateKey key = this.crypto.getPrivateKey("wss40", "security");
        sigBuilder.setExternalKey(key.getEncoded(), secToken.getElement());
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.build(doc, secHeader);
        sigBuilder.prependDKElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: ThumbprintSHA1 + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        DerivedKeyTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(doc), (int)2)) != null ? 1 : 0) != 0);
        DerivedKeyTest.assertFalse((boolean)actionResult.isEmpty());
        DerivedKeyTest.assertTrue((actionResult.get((Object)"secret") != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureSKI() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        secToken.setKeyIdentifierSKI(certs[0], this.crypto);
        WSSecDKSign sigBuilder = new WSSecDKSign();
        PrivateKey key = this.crypto.getPrivateKey("wss40", "security");
        sigBuilder.setExternalKey(key.getEncoded(), secToken.getElement());
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.build(doc, secHeader);
        sigBuilder.prependDKElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: SKI + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        DerivedKeyTest.assertTrue(((actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(doc), (int)2)) != null ? 1 : 0) != 0);
        DerivedKeyTest.assertFalse((boolean)actionResult.isEmpty());
        DerivedKeyTest.assertTrue((actionResult.get((Object)"secret") != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureEncrypt() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.prepare(doc, this.crypto);
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(ek, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        LOG.info("Before HMAC-SHA1 signature");
        Document signedDoc = sigBuilder.build(doc, secHeader);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(ek, tokenIdentifier);
        Document signedEncryptedDoc = encrBuilder.build(signedDoc, secHeader);
        encrKeyBuilder.prependToHeader(secHeader);
        encrKeyBuilder.prependBSTElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedEncryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedEncryptedDoc);
    }

    @Test
    public void testEncryptSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        encrKeyBuilder.prepare(doc, this.crypto);
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt();
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setExternalKey(ek, tokenIdentifier);
        encrBuilder.build(doc, secHeader);
        WSSecDKSign sigBuilder = new WSSecDKSign();
        sigBuilder.setExternalKey(ek, tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        LOG.info("Before HMAC-SHA1 signature");
        Document encryptedSignedDoc = sigBuilder.build(doc, secHeader);
        encrKeyBuilder.prependToHeader(secHeader);
        encrKeyBuilder.prependBSTElementToHeader(secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        DerivedKeyTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

