/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModifiedRequestTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiedRequestTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"http://blah.com\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public ModifiedRequestTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testMovedElement() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        LOG.info("Before Signing....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("value", "http://blah.com", "");
        parts.add(encP);
        builder.setParts(parts);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        Element secHeaderElement = secHeader.getSecurityHeader();
        Element envelopeElement = signedDoc.getDocumentElement();
        Node valueNode = envelopeElement.getElementsByTagNameNS("http://blah.com", "value").item(0);
        Node clonedValueNode = valueNode.cloneNode(true);
        secHeaderElement.appendChild(clonedValueNode);
        valueNode.getFirstChild().setNodeValue("250");
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            ModifiedRequestTest.fail((String)"Failure expected on multiple elements with the same wsu:Id");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            ModifiedRequestTest.assertTrue((boolean)ex.getMessage().startsWith("javax.xml.crypto.URIReferenceException: org.apache.xml.security.utils.resolver.ResourceResolverException: Cannot resolve element with ID "));
        }
    }

    @Test
    public void testMovedElementChangedId() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        LOG.info("Before Signing....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("value", "http://blah.com", "");
        parts.add(encP);
        builder.setParts(parts);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        Element secHeaderElement = secHeader.getSecurityHeader();
        Element envelopeElement = signedDoc.getDocumentElement();
        Node valueNode = envelopeElement.getElementsByTagNameNS("http://blah.com", "value").item(0);
        Node clonedValueNode = valueNode.cloneNode(true);
        secHeaderElement.appendChild(clonedValueNode);
        valueNode.getFirstChild().setNodeValue("250");
        String savedId = ((Element)valueNode).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        ((Element)valueNode).setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "id-250");
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        WSSecurityUtil.checkSignsAllElements((WSSecurityEngineResult)actionResult, (String[])new String[]{savedId});
        envelopeElement = signedDoc.getDocumentElement();
        Node bodyNode = envelopeElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        valueNode = ((Element)bodyNode).getElementsByTagNameNS("http://blah.com", "value").item(0);
        String actualId = ((Element)valueNode).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        try {
            WSSecurityUtil.checkSignsAllElements((WSSecurityEngineResult)actionResult, (String[])new String[]{actualId});
            ModifiedRequestTest.fail((String)"Failure expected on bad wsu:Id");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            ModifiedRequestTest.assertEquals((Object)"Element id-250 is not included in the signature", (Object)ex.getMessage());
        }
    }

    @Test
    public void testDuplicatedSignedSAMLAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security", secHeader);
        Element assertionElement = (Element)samlAssertion.getElement().cloneNode(true);
        assertionElement.removeChild(assertionElement.getFirstChild());
        secHeader.getSecurityHeader().appendChild(assertionElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            ModifiedRequestTest.fail((String)"Failure expected on duplicate tokens");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((boolean)ex.getMessage().contains("Multiple security tokens with the same Id have been detected"));
        }
    }

    @Test
    public void testDuplicatedSignedUsernameToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecUsernameToken usernameToken = new WSSecUsernameToken();
        usernameToken.setUserInfo("wss86", "security");
        Document createdDoc = usernameToken.build(doc, secHeader);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("UsernameToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "");
        parts.add(encP);
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setParts(parts);
        builder.prepare(createdDoc, this.crypto, secHeader);
        List referenceList = builder.addReferencesToSign(parts, secHeader);
        builder.computeSignature(referenceList, false, null);
        secHeader.getSecurityHeader().appendChild(usernameToken.getUsernameTokenElement().cloneNode(true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed Timestamp");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            ModifiedRequestTest.fail((String)"Failure expected on duplicate tokens");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((boolean)ex.getMessage().contains("Multiple security tokens with the same Id have been detected"));
        }
    }

    @Test
    public void testModifiedEncryptedDataStructure() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document encryptedDoc = builder.build(doc, wssCrypto, secHeader);
        Element body = WSSecurityUtil.findBodyElement((Document)doc);
        Element encryptionMethod = WSSecurityUtil.findElement((Node)body, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        encryptionMethod.setAttributeNS(null, "Algorithm", "http://new-algorithm");
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            ModifiedRequestTest.fail((String)"Failure expected on a modified EncryptedData structure");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testModifiedEncryptedDataCipherValue() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document encryptedDoc = builder.build(doc, wssCrypto, secHeader);
        Element body = WSSecurityUtil.findBodyElement((Document)doc);
        Element cipherValue = WSSecurityUtil.findElement((Node)body, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        String cipherText = cipherValue.getTextContent();
        StringBuilder stringBuilder = new StringBuilder(cipherText);
        int index = stringBuilder.length() / 2;
        char ch = stringBuilder.charAt(index);
        ch = ch != 'A' ? (char)'A' : 'B';
        stringBuilder.setCharAt(index, ch);
        cipherValue.setTextContent(stringBuilder.toString());
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            ModifiedRequestTest.fail((String)"Failure expected on a modified EncryptedData CipherValue");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedEncryptedKeyCipherValue() throws Exception {
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document encryptedDoc = builder.build(doc, wssCrypto, secHeader);
        Element encryptedKey = WSSecurityUtil.findElement((Node)doc.getDocumentElement(), (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
        Element cipherValue = WSSecurityUtil.findElement((Node)encryptedKey, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        String cipherText = cipherValue.getTextContent();
        StringBuilder stringBuilder = new StringBuilder(cipherText);
        int index = stringBuilder.length() / 2;
        char ch = stringBuilder.charAt(index);
        ch = ch != 'A' ? (char)'A' : 'B';
        stringBuilder.setCharAt(index, ch);
        cipherValue.setTextContent(stringBuilder.toString());
        String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            ModifiedRequestTest.fail((String)"Failure expected on a modified EncryptedData CipherValue");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedSignatureReference() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecTimestamp timestamp = new WSSecTimestamp();
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build(doc, secHeader);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        parts.add(encP);
        builder.setParts(parts);
        Document signedDoc = builder.build(createdDoc, this.crypto, secHeader);
        Element timestampElement = timestamp.getElement();
        Element createdValue = WSSecurityUtil.findElement((Node)timestampElement, (String)"Created", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        createdValue.setTextContent(zulu.format(new Date()));
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            ModifiedRequestTest.fail((String)"Failure expected on a modified Signature Reference");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            ModifiedRequestTest.assertEquals((Object)"The signature or decryption was invalid", (Object)ex.getMessage());
        }
    }

    @Test
    public void testUntrustedSignature() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("wss40", "security");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Crypto wss40Crypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document signedDoc = builder.build(doc, wss40Crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            ModifiedRequestTest.fail((String)"Failure expected on an untrusted Certificate");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            ModifiedRequestTest.assertEquals((Object)"The signature or decryption was invalid", (Object)ex.getMessage());
        }
    }

    @Test
    public void testModifiedSignature() throws Exception {
        WSSecSignature builder = new WSSecSignature();
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, this.crypto, secHeader);
        Element signatureElement = builder.getSignatureElement();
        Node firstChild = signatureElement.getFirstChild();
        while (!(firstChild instanceof Element) && firstChild != null) {
            firstChild = signatureElement.getNextSibling();
        }
        ((Element)firstChild).setAttributeNS(null, "Id", "xyz");
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            ModifiedRequestTest.fail((String)"Failure expected on a modified Signature element");
        }
        catch (WSSecurityException ex) {
            ModifiedRequestTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            ModifiedRequestTest.assertEquals((Object)"The signature or decryption was invalid", (Object)ex.getMessage());
        }
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
    }
}

