/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.Collections;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PasswordTypeTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordTypeTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    @Test
    public void testPasswordDigest() throws Exception {
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setUserInfo("wernerd", "verySecret");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message with UserNameToken PW Digest:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setRequiredPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
        secEngine.setWssConfig(wssConfig);
        secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
        wssConfig.setRequiredPasswordType(null);
        secEngine.setWssConfig(wssConfig);
        secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
        try {
            wssConfig.setRequiredPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            secEngine.setWssConfig(wssConfig);
            secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
            PasswordTypeTest.fail((String)"Expected failure on the wrong password type");
        }
        catch (WSSecurityException ex) {
            PasswordTypeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUsernameTokenText() throws Exception {
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.setUserInfo("wernerd", "verySecret");
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = builder.build(doc, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message with UserNameToken PW Text:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setRequiredPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        secEngine.setWssConfig(wssConfig);
        secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
        wssConfig.setRequiredPasswordType(null);
        secEngine.setWssConfig(wssConfig);
        secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
        try {
            wssConfig.setRequiredPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            secEngine.setWssConfig(wssConfig);
            secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
            PasswordTypeTest.fail((String)"Expected failure on the wrong password type");
        }
        catch (WSSecurityException ex) {
            PasswordTypeTest.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUsernameTokenWSHandler() throws Exception {
        CustomHandler handler = new CustomHandler();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        RequestData reqData = new RequestData();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("password", "verySecret");
        config.put("passwordType", "PasswordText");
        reqData.setUsername("wernerd");
        reqData.setMsgContext(config);
        HandlerAction action = new HandlerAction(Integer.valueOf(1));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Username Token via WSHandler");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        config.put("passwordType", "PasswordDigest");
        reqData.setMsgContext(config);
        handler.receive(Collections.singletonList(1), reqData);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.setWssConfig(reqData.getWssConfig());
        try {
            secEngine.processSecurityHeader(doc, null, this.callbackHandler, null);
            PasswordTypeTest.fail((String)"Expected failure on the wrong password type");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }
}

