/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureCRLTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureCRLTest.class);
    private Crypto crypto = null;
    private Crypto cryptoCA = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignatureCRLTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40rev.properties");
        this.cryptoCA = CryptoFactory.getInstance((String)"wss40CA.properties");
    }

    @Test
    public void testSignatureDirectReference() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult result;
        X509Certificate cert;
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40rev", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        SignatureCRLTest.assertTrue(((cert = (X509Certificate)(result = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.cryptoCA, false), (int)2)).get((Object)"x509-certificate")) != null ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureDirectReferenceRevocation() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40rev", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc, this.cryptoCA, true);
            SignatureCRLTest.fail((String)"Failure expected on a revoked certificate");
        }
        catch (Exception ex) {
            String errorMessage = ex.getMessage();
            SignatureCRLTest.assertTrue((errorMessage.contains("Certificate has been revoked") || errorMessage.contains("Certificate revocation") || errorMessage.contains("Error during certificate path validation") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSignatureDirectReferenceRevocationKeyStore() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40rev", "security");
        sign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc, this.crypto, true);
            SignatureCRLTest.fail((String)"Failure expected on a revoked certificate");
        }
        catch (Exception ex) {
            String errorMessage = ex.getMessage();
            SignatureCRLTest.assertTrue((errorMessage.contains("Certificate has been revoked") || errorMessage.contains("Certificate revocation") || errorMessage.contains("Error during certificate path validation") ? 1 : 0) != 0);
        }
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto crypto, boolean revocationEnabled) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData reqData = new RequestData();
        reqData.setSigVerCrypto(crypto);
        reqData.setEnableRevocation(revocationEnabled);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, null);
        List results = secEngine.processSecurityHeader(securityHeader, reqData);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

