/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureEncryptionTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureEncryptionTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"http://blah.com\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignatureEncryptionTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testEncryptionSigning() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        WSSecSignature sign = new WSSecSignature();
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Encryption....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Document encryptedSignedDoc = sign.build(encryptedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testEncryptionElementSigning() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        WSSecSignature sign = new WSSecSignature();
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> encParts = new ArrayList<WSEncryptionPart>();
        encParts.add(new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element"));
        encrypt.setParts(encParts);
        Document encryptedDoc = encrypt.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Encryption....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        sigParts.add(new WSEncryptionPart("EncryptedData", "http://www.w3.org/2001/04/xmlenc#", "Element"));
        sign.setParts(sigParts);
        Document encryptedSignedDoc = sign.build(encryptedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(encryptedSignedDoc);
        List sigSecEngResults = WSSecurityUtil.fetchAllActionResults(results, (int)2);
        List encSecEngResults = WSSecurityUtil.fetchAllActionResults(results, (int)4);
        SignatureEncryptionTest.assertEquals((long)1L, (long)sigSecEngResults.size());
        SignatureEncryptionTest.assertEquals((long)1L, (long)encSecEngResults.size());
        List sigDataRefs = (List)((WSSecurityEngineResult)sigSecEngResults.get(0)).get((Object)"data-ref-uris");
        List encDataRefs = (List)((WSSecurityEngineResult)encSecEngResults.get(0)).get((Object)"data-ref-uris");
        SignatureEncryptionTest.assertNotNull((Object)sigDataRefs);
        SignatureEncryptionTest.assertNotNull((Object)encDataRefs);
        SignatureEncryptionTest.assertEquals((long)1L, (long)sigDataRefs.size());
        SignatureEncryptionTest.assertEquals((long)1L, (long)encDataRefs.size());
        SignatureEncryptionTest.assertNull((Object)((WSDataRef)sigDataRefs.get(0)).getProtectedElement().getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        SignatureEncryptionTest.assertTrue((boolean)((WSDataRef)sigDataRefs.get(0)).getWsuId().contains(((WSDataRef)encDataRefs.get(0)).getWsuId()));
    }

    @Test
    public void testSigningEncryption() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        WSSecSignature sign = new WSSecSignature();
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        Document encryptedSignedDoc = encrypt.build(signedDoc, this.crypto, secHeader);
        LOG.info("After Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testWSS198() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        WSSecSignature sign = new WSSecSignature();
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "");
        parts.add(encP);
        encrypt.setParts(parts);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        Document encryptedSignedDoc = encrypt.build(signedDoc, this.crypto, secHeader);
        LOG.info("WSS198");
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testSigningEncryptionIS3DES() throws Exception {
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setUserInfo("wss40");
        encrypt.setKeyIdentifierType(2);
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(2);
        LOG.info("Before Sign/Encryption....");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        Document encryptedSignedDoc = encrypt.build(signedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Sign/Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testEncryptedKeySignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        LOG.info("Before Sign/Encryption....");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        encrKey.setKeyIdentifierType(2);
        encrKey.setUserInfo("wss40", "security");
        encrKey.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        encrKey.prepare(doc, this.crypto);
        WSSecEncrypt encrypt = new WSSecEncrypt();
        encrypt.setEncKeyId(encrKey.getId());
        encrypt.setEphemeralKey(encrKey.getEphemeralKey());
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        encrypt.setEncryptSymmKey(false);
        encrypt.setEncryptedKeyElement(encrKey.getEncryptedKeyElement());
        WSSecSignature sign = new WSSecSignature();
        sign.setKeyIdentifierType(9);
        sign.setCustomTokenId(encrKey.getId());
        sign.setSecretKey(encrKey.getEphemeralKey());
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        Document encryptedSignedDoc = encrypt.build(signedDoc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Sign/Encryption....");
        this.verify(encryptedSignedDoc);
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List resultList = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return resultList;
    }
}

