/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.saml.SignedSamlTokenHOKTest;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignaturePartsTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePartsTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private static final String SOAPMSG_MULTIPLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf1</ns1:testMethod>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf2</ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto = null;

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignaturePartsTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testSOAPHeader() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        QName name = new QName("urn:foo.bar", "foobar");
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{name});
        try {
            name = new QName("urn:foo.bar", "foobar2");
            WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{name});
            SignaturePartsTest.fail((String)"Failure expected on a wrong protected part");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        try {
            name = new QName("urn:foo.bar", "foobar");
            WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{name});
            SignaturePartsTest.fail((String)"Failure expected on a wrong action");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignaturePartsTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignaturePartsTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignaturePartsTest.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
        SignaturePartsTest.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)wsDataRef.getAlgorithm());
        SignaturePartsTest.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)wsDataRef.getDigestAlgorithm());
        String sigMethod = (String)actionResult.get((Object)"signature-method");
        SignaturePartsTest.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)sigMethod);
        String c14nMethod = (String)actionResult.get((Object)"canonicalization-method");
        SignaturePartsTest.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)c14nMethod);
        List transformAlgorithms = wsDataRef.getTransformAlgorithms();
        SignaturePartsTest.assertTrue((transformAlgorithms.size() == 1 ? 1 : 0) != 0);
        SignaturePartsTest.assertTrue((boolean)"http://www.w3.org/2001/10/xml-exc-c14n#".equals(transformAlgorithms.get(0)));
    }

    @Test
    public void testOptionalSOAPHeaderPresent() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testOptionalSOAPHeaderNotPresent() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testRequiredSOAPHeaderNotPresent() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        parts.add(encP);
        sign.setParts(parts);
        try {
            sign.build(doc, this.crypto, secHeader);
            SignaturePartsTest.fail((String)"Failure expected on not signing a required element");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSOAPHeaderSTRTransform() throws Exception {
        Merlin issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignedSamlTokenHOKTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        issuerCrypto.setKeyStore(keyStore);
        Crypto userCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        samlCallback.setIssuer("www.example.com");
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", (Crypto)issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setKeyIdentifierType(1);
        wsSign.setUserInfo("wss40", "security");
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("STRTransform", "", "Element");
        parts.add(encP);
        wsSign.setParts(parts);
        Document signedDoc = wsSign.build(doc, userCrypto, samlAssertion, null, null, null, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message (key holder):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Merlin trustCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        trustCrypto.setTrustStore(trustStore);
        List results = this.secEngine.processSecurityHeader(doc, null, null, (Crypto)trustCrypto);
        WSSecurityEngineResult stUnsignedActionResult = WSSecurityUtil.fetchActionResult((List)results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)stUnsignedActionResult.get((Object)"saml-assertion");
        SignaturePartsTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SignaturePartsTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        WSSecurityEngineResult signActionResult = WSSecurityUtil.fetchActionResult((List)results, (int)2);
        SignaturePartsTest.assertTrue((signActionResult != null ? 1 : 0) != 0);
        SignaturePartsTest.assertFalse((boolean)signActionResult.isEmpty());
        List refs = (List)signActionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignaturePartsTest.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testBadLocalname() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar2", "urn:foo.bar", "");
        parts.add(encP);
        sign.setParts(parts);
        try {
            sign.build(doc, this.crypto, secHeader);
            SignaturePartsTest.fail((String)"Failure expected on a bad localname");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBadNamespace() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar2", "");
        parts.add(encP);
        sign.setParts(parts);
        try {
            sign.build(doc, this.crypto, secHeader);
            SignaturePartsTest.fail((String)"Failure expected on a bad namespace");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSOAPHeaderAndBody() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "");
        parts.add(encP);
        WSEncryptionPart encP2 = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        parts.add(encP2);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        QName fooName = new QName("urn:foo.bar", "foobar");
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{fooName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{bodyName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{bodyName, fooName});
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{fooName, bodyName});
        try {
            WSSecurityUtil.checkAllElementsProtected(results, (int)4, (QName[])new QName[]{fooName, bodyName});
            SignaturePartsTest.fail((String)"Failure expected on a wrong action");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
        try {
            QName headerName = new QName(soapConstants.getEnvelopeURI(), "Header");
            WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{fooName, bodyName, headerName});
            SignaturePartsTest.fail((String)"Failure expected on an unsatisfied requirement");
        }
        catch (WSSecurityException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSignaturePartDOMElement() throws Exception {
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("Incorrect Localname", "Incorrect N/S", "");
        Element bodyElement = WSSecurityUtil.findBodyElement((Document)doc);
        SignaturePartsTest.assertTrue((bodyElement != null && "Body".equals(bodyElement.getLocalName()) ? 1 : 0) != 0);
        encP.setElement(bodyElement);
        parts.add(encP);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        List<WSSecurityEngineResult> results = this.verify(signedDoc);
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        WSSecurityUtil.checkAllElementsProtected(results, (int)2, (QName[])new QName[]{bodyName});
    }

    @Test
    public void testMultipleElements() throws Exception {
        Document doc = SOAPUtil.toSOAPPart(SOAPMSG_MULTIPLE);
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("testMethod", "http://axis/service/security/test6/LogTestService8", "");
        parts.add(encP);
        sign.setParts(parts);
        Document signedDoc = sign.build(doc, this.crypto, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

