/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReferenceListDataRefTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceListDataRefTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public ReferenceListDataRefTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testDataRefReferenceListProcessor() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecEncrypt builder = new WSSecEncrypt();
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        LOG.info("Before Encryption Triple DES....");
        builder.prepare(doc, this.crypto);
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        parts.add(encP);
        Element refs = builder.encryptForRef(null, parts);
        builder.addExternalRefElement(refs, secHeader);
        builder.prependToHeader(secHeader);
        builder.prependBSTElementToHeader(secHeader);
        Document encryptedDoc = doc;
        LOG.info("After Encryption Triple DES....");
        this.checkDataRef(encryptedDoc);
    }

    private void checkDataRef(Document doc) throws Exception {
        List wsResults = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        boolean found = false;
        for (int i = 0; i < wsResults.size(); ++i) {
            List dataRefs;
            WSSecurityEngineResult wsSecEngineResult = (WSSecurityEngineResult)wsResults.get(i);
            int action = (Integer)wsSecEngineResult.get((Object)"action");
            if (action != 4 || (dataRefs = (List)wsSecEngineResult.get((Object)"data-ref-uris")) == null || dataRefs.size() <= 0) continue;
            for (int j = 0; j < dataRefs.size(); ++j) {
                Object obj = dataRefs.get(i);
                ReferenceListDataRefTest.assertTrue((boolean)(obj instanceof WSDataRef));
                WSDataRef dataRef = (WSDataRef)obj;
                ReferenceListDataRefTest.assertEquals((Object)"add", (Object)dataRef.getName().getLocalPart());
                ReferenceListDataRefTest.assertEquals((Object)"http://ws.apache.org/counter/counter_port_type", (Object)dataRef.getName().getNamespaceURI());
                ReferenceListDataRefTest.assertNotNull((Object)dataRef.getWsuId());
                ReferenceListDataRefTest.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", (Object)dataRef.getAlgorithm());
                found = true;
            }
        }
        ReferenceListDataRefTest.assertTrue((boolean)found);
    }
}

