/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.ProxyRestrictionBean;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomSamlAssertionValidator;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSAMLToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.Validator;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SamlConditionsTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SamlConditionsTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SamlConditionsTest() {
        WSSConfig config = WSSConfig.getNewInstance();
        config.setValidator(WSSecurityEngine.SAML_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidator(WSSecurityEngine.SAML2_TOKEN, (Validator)new CustomSamlAssertionValidator());
        config.setValidateSamlSubjectConfirmation(false);
        this.secEngine.setWssConfig(config);
    }

    @Test
    public void testSAML1Conditions() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        DateTime notBefore = new DateTime();
        conditions.setNotBefore(notBefore);
        conditions.setNotAfter(notBefore.plusMinutes(20));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        SamlConditionsTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(unsignedDoc), (int)8)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SamlConditionsTest.assertFalse((boolean)receivedSamlAssertion.isSigned());
        SamlConditionsTest.assertTrue((receivedSamlAssertion.getSignatureValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSAML2InvalidAfterConditions() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        DateTime notBefore = new DateTime();
        conditions.setNotBefore(notBefore.minusMinutes(5));
        conditions.setNotAfter(notBefore.minusMinutes(3));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(unsignedDoc);
            SamlConditionsTest.fail((String)"Failure expected in processing the SAML Conditions element");
        }
        catch (WSSecurityException ex) {
            SamlConditionsTest.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
        }
    }

    @Test
    public void testSAML2InvalidBeforeConditions() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        DateTime notBefore = new DateTime();
        conditions.setNotBefore(notBefore.plusMinutes(2));
        conditions.setNotAfter(notBefore.plusMinutes(5));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(unsignedDoc);
            SamlConditionsTest.fail((String)"Failure expected in processing the SAML Conditions element");
        }
        catch (WSSecurityException ex) {
            SamlConditionsTest.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
        }
    }

    @Test
    public void testSAML2FutureTTLConditions() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        DateTime notBefore = new DateTime();
        conditions.setNotBefore(notBefore.plusSeconds(30));
        conditions.setNotAfter(notBefore.plusMinutes(5));
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
            LOG.debug(outputString);
        }
        this.verify(unsignedDoc);
    }

    @Test
    public void testSAML2OneTimeUse() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        conditions.setOneTimeUse(true);
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        SamlConditionsTest.assertTrue((boolean)outputString.contains("OneTimeUse"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(unsignedDoc);
    }

    @Test
    public void testSAML2ProxyRestriction() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setIssuer("www.example.com");
        ConditionsBean conditions = new ConditionsBean();
        conditions.setTokenPeriodMinutes(5);
        ProxyRestrictionBean proxyRestriction = new ProxyRestrictionBean();
        ArrayList<String> audiences = new ArrayList<String>();
        audiences.add("http://apache.org/one");
        audiences.add("http://apache.org/two");
        proxyRestriction.getAudienceURIs().addAll(audiences);
        proxyRestriction.setCount(5);
        conditions.setProxyRestriction(proxyRestriction);
        callbackHandler.setConditions(conditions);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        WSSecSAMLToken wsSign = new WSSecSAMLToken();
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document unsignedDoc = wsSign.build(doc, samlAssertion, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)unsignedDoc);
        SamlConditionsTest.assertTrue((boolean)outputString.contains("ProxyRestriction"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(unsignedDoc);
    }

    private List<WSSecurityEngineResult> verify(Document doc) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, null, null);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SamlConditionsTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

