/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.common.SOAPUtil;
import org.apache.wss4j.dom.common.SecurityTestUtil;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignedSamlTokenHOKTest
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(SignedSamlTokenHOKTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto trustCrypto = null;
    private Crypto issuerCrypto = null;
    private Crypto userCrypto = CryptoFactory.getInstance((String)"wss40.properties");

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
    }

    public SignedSamlTokenHOKTest() throws Exception {
        WSSConfig.init();
        this.issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignedSamlTokenHOKTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        ((Merlin)this.issuerCrypto).setKeyStore(keyStore);
        this.trustCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        ((Merlin)this.trustCrypto).setTrustStore(trustStore);
    }

    @Test
    public void testSAML1AuthnAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion.getSignatureValue() != null ? 1 : 0) != 0);
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        wsSign.setKeyIdentifierType(3);
        wsSign.setSecretKey(ephemeralKey);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Attr Assertion (key holder):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue(((receivedAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.trustCrypto), (int)16)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AuthnAssertion() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.trustCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AttrAssertion() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedAssertion;
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.ATTR);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        wsSign.setKeyIdentifierType(3);
        wsSign.setSecretKey(ephemeralKey);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 2 Attr Assertion (key holder):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue(((receivedAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.trustCrypto), (int)16)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionIssuerSerial() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.X509_ISSUER_SERIAL);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion Issuer Serial (holder-of-key):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("X509IssuerSerial"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionKeyValue() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion Key Value (holder-of-key):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("KeyValue"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        assert (receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML2AuthnAssertionKeyValue() throws Exception {
        SAML2CallbackHandler callbackHandler = new SAML2CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("wss40", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, this.userCrypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 2 Authn Assertion Key Value (holder-of-key):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue((boolean)outputString.contains("KeyValue"));
        List<WSSecurityEngineResult> results = this.verify(signedDoc, this.userCrypto);
        WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(results, (int)16);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)actionResult.get((Object)"saml-assertion");
        SignedSamlTokenHOKTest.assertTrue((receivedSamlAssertion != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    @Test
    public void testSAML1AuthnAssertionTrust() throws Exception {
        List<WSSecurityEngineResult> results;
        WSSecurityEngineResult actionResult;
        SamlAssertionWrapper receivedSamlAssertion;
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        callbackHandler.setIssuer("www.example.com");
        Crypto crypto = CryptoFactory.getInstance((String)"crypto.properties");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("16c73ab6-b892-458f-abf5-2f875f74882e");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        callbackHandler.setCerts(certs);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", this.issuerCrypto, false);
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML();
        wsSign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        wsSign.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        wsSign.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        wsSign.setKeyIdentifierType(1);
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader();
        secHeader.insertSecurityHeader(doc);
        Document signedDoc = wsSign.build(doc, crypto, samlAssertion, null, null, null, secHeader);
        String outputString = XMLUtils.PrettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML 1.1 Authn Assertion (key holder):");
            LOG.debug(outputString);
        }
        SignedSamlTokenHOKTest.assertTrue(((receivedSamlAssertion = (SamlAssertionWrapper)(actionResult = WSSecurityUtil.fetchActionResult(results = this.verify(signedDoc, this.trustCrypto), (int)16)).get((Object)"saml-assertion")) != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertTrue((boolean)receivedSamlAssertion.isSigned());
        actionResult = WSSecurityUtil.fetchActionResult(results, (int)2);
        SignedSamlTokenHOKTest.assertTrue((actionResult != null ? 1 : 0) != 0);
        SignedSamlTokenHOKTest.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        SignedSamlTokenHOKTest.assertTrue((refs.size() == 1 ? 1 : 0) != 0);
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        SignedSamlTokenHOKTest.assertEquals((Object)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Object)xpath);
    }

    private List<WSSecurityEngineResult> verify(Document doc, Crypto sigCrypto) throws Exception {
        List results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, sigCrypto, this.userCrypto);
        String outputString = XMLUtils.PrettyDocumentToString((Document)doc);
        SignedSamlTokenHOKTest.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

