/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.saml;

import java.math.BigInteger;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.token.DOMX509Data;
import org.apache.wss4j.common.token.DOMX509IssuerSerial;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.token.X509Security;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecSignatureSAML
extends WSSecSignature {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecSignatureSAML.class);
    private boolean senderVouches;
    private SecurityTokenReference secRefSaml;
    private String secRefID;
    private Element samlToken;
    private Crypto userCrypto;
    private Crypto issuerCrypto;
    private String issuerKeyName;
    private String issuerKeyPW;
    private boolean useDirectReferenceToAssertion;

    public WSSecSignatureSAML() {
        this.doDebug = LOG.isDebugEnabled();
    }

    public Document build(Document doc, Crypto uCrypto, SamlAssertionWrapper samlAssertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        this.prepare(doc, uCrypto, samlAssertion, iCrypto, iKeyName, iKeyPW, secHeader);
        if (this.getParts().isEmpty()) {
            this.getParts().add(WSSecurityUtil.getDefaultEncryptionPart(doc));
        } else {
            for (WSEncryptionPart part : this.getParts()) {
                if (!"STRTransform".equals(part.getName()) || part.getId() != null) continue;
                part.setId(this.strUri);
            }
        }
        if (this.secRefID != null) {
            String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
            WSEncryptionPart encP = new WSEncryptionPart("STRTransform", soapNamespace, "Content");
            encP.setId(this.secRefID);
            this.getParts().add(encP);
        }
        List<Reference> referenceList = this.addReferencesToSign(this.getParts(), secHeader);
        this.prependSAMLElementsToHeader(secHeader);
        if (this.senderVouches) {
            this.computeSignature(referenceList, secHeader, this.secRefSaml.getElement());
        } else {
            this.computeSignature(referenceList, secHeader, this.samlToken);
        }
        if (this.bstToken != null) {
            this.prependBSTElementToHeader(secHeader);
        }
        return doc;
    }

    public void prepare(Document doc, Crypto uCrypto, SamlAssertionWrapper samlAssertion, Crypto iCrypto, String iKeyName, String iKeyPW, WSSecHeader secHeader) throws WSSecurityException {
        SecurityTokenReference secRef;
        block49: {
            Element elem;
            String valueType;
            Element keyId;
            org.apache.wss4j.common.token.Reference ref;
            block48: {
                if (this.doDebug) {
                    LOG.debug("Beginning ST signing...");
                }
                this.userCrypto = uCrypto;
                this.issuerCrypto = iCrypto;
                this.document = doc;
                this.issuerKeyName = iKeyName;
                this.issuerKeyPW = iKeyPW;
                this.samlToken = samlAssertion.toDOM(doc);
                String confirmMethod = null;
                List methods = samlAssertion.getConfirmationMethods();
                if (methods != null && methods.size() > 0) {
                    confirmMethod = (String)methods.get(0);
                }
                if (OpenSAMLUtil.isMethodSenderVouches(confirmMethod)) {
                    this.senderVouches = true;
                }
                this.wsDocInfo = new WSDocInfo(doc);
                X509Certificate[] certs = null;
                Key publicKey = null;
                if (this.senderVouches) {
                    CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                    cryptoType.setAlias(this.issuerKeyName);
                    certs = this.issuerCrypto.getX509Certificates(cryptoType);
                    this.wsDocInfo.setCrypto(this.issuerCrypto);
                } else {
                    if (this.userCrypto == null || !samlAssertion.isSigned()) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[]{"for SAML Signature (Key Holder)"});
                    }
                    if (this.secretKey == null) {
                        RequestData data = new RequestData();
                        SignatureActionToken actionToken = new SignatureActionToken();
                        data.setSignatureToken(actionToken);
                        actionToken.setCrypto(this.userCrypto);
                        SAMLKeyInfo samlKeyInfo = SAMLUtil.getCredentialFromSubject((SamlAssertionWrapper)samlAssertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data, this.wsDocInfo), (Crypto)this.userCrypto, (CallbackHandler)data.getCallbackHandler());
                        if (samlKeyInfo != null) {
                            publicKey = samlKeyInfo.getPublicKey();
                            certs = samlKeyInfo.getCerts();
                            this.wsDocInfo.setCrypto(this.userCrypto);
                        }
                    }
                }
                if ((certs == null || certs.length == 0 || certs[0] == null) && publicKey == null && this.secretKey == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCertsFound", new Object[]{"SAML signature"});
                }
                if (this.getSignatureAlgorithm() == null) {
                    Key key = null;
                    if (certs != null && certs[0] != null) {
                        key = certs[0].getPublicKey();
                    } else if (publicKey != null) {
                        key = publicKey;
                    } else {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unknownSignatureAlgorithm");
                    }
                    String pubKeyAlgo = key.getAlgorithm();
                    LOG.debug("automatic sig algo detection: " + pubKeyAlgo);
                    if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                        this.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
                    } else if (pubKeyAlgo.equalsIgnoreCase("RSA")) {
                        this.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                    } else {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unknownSignatureAlgorithm", new Object[]{pubKeyAlgo});
                    }
                }
                this.sig = null;
                try {
                    ExcC14NParameterSpec c14nSpec = null;
                    if (this.isAddInclusivePrefixes() && this.getSigCanonicalization().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                        List<String> prefixes = this.getInclusivePrefixes(secHeader.getSecurityHeader(), false);
                        c14nSpec = new ExcC14NParameterSpec(prefixes);
                    }
                    this.c14nMethod = this.signatureFactory.newCanonicalizationMethod(this.getSigCanonicalization(), c14nSpec);
                }
                catch (Exception ex) {
                    LOG.error("", (Throwable)ex);
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, ex, "noXMLSig");
                }
                this.keyInfoUri = this.getIdAllocator().createSecureId("KeyId-", this.keyInfo);
                secRef = new SecurityTokenReference(doc);
                this.strUri = this.getIdAllocator().createSecureId("STRId-", secRef);
                secRef.setID(this.strUri);
                this.setSecurityTokenReference(secRef);
                if (certs != null && certs.length != 0) {
                    this.certUri = this.getIdAllocator().createSecureId("CertId-", certs[0]);
                }
                try {
                    if (this.senderVouches) {
                        this.secRefSaml = new SecurityTokenReference(doc);
                        this.secRefID = this.getIdAllocator().createSecureId("STRSAMLId-", this.secRefSaml);
                        this.secRefSaml.setID(this.secRefID);
                        if (this.useDirectReferenceToAssertion) {
                            ref = new org.apache.wss4j.common.token.Reference(doc);
                            ref.setURI("#" + samlAssertion.getId());
                            if (samlAssertion.getSaml1() != null) {
                                ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                                this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                            } else if (samlAssertion.getSaml2() != null) {
                                this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                            }
                            this.secRefSaml.setReference(ref);
                        } else {
                            keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
                            valueType = null;
                            if (samlAssertion.getSaml1() != null) {
                                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                                this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                            } else if (samlAssertion.getSaml2() != null) {
                                valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                                this.secRefSaml.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                            }
                            keyId.setAttributeNS(null, "ValueType", valueType);
                            keyId.appendChild(doc.createTextNode(samlAssertion.getId()));
                            elem = this.secRefSaml.getElement();
                            elem.appendChild(keyId);
                        }
                        this.wsDocInfo.addTokenElement(this.secRefSaml.getElement(), false);
                    }
                }
                catch (Exception ex) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, ex, "noXMLSig");
                }
                if (!this.senderVouches) break block48;
                switch (this.keyIdentifierType) {
                    case 1: {
                        ref = new org.apache.wss4j.common.token.Reference(doc);
                        ref.setURI("#" + this.certUri);
                        X509Security binarySecurity = new X509Security(doc);
                        binarySecurity.setX509Certificate(certs[0]);
                        binarySecurity.setID(this.certUri);
                        this.bstToken = binarySecurity.getElement();
                        this.wsDocInfo.addTokenElement(this.bstToken, false);
                        ref.setValueType(binarySecurity.getValueType());
                        secRef.setReference(ref);
                        break block49;
                    }
                    case 3: {
                        secRef.setKeyIdentifier(certs[0]);
                        break block49;
                    }
                    case 4: {
                        secRef.setKeyIdentifierSKI(certs[0], iCrypto != null ? iCrypto : uCrypto);
                        break block49;
                    }
                    case 8: {
                        secRef.setKeyIdentifierThumb(certs[0]);
                        break block49;
                    }
                    case 2: {
                        String issuer = certs[0].getIssuerDN().getName();
                        BigInteger serialNumber = certs[0].getSerialNumber();
                        DOMX509IssuerSerial domIssuerSerial = new DOMX509IssuerSerial(this.document, issuer, serialNumber);
                        DOMX509Data domX509Data = new DOMX509Data(this.document, domIssuerSerial);
                        secRef.setUnknownElement(domX509Data.getElement());
                        break block49;
                    }
                    default: {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedKeyId");
                    }
                }
            }
            if (this.useDirectReferenceToAssertion) {
                ref = new org.apache.wss4j.common.token.Reference(doc);
                ref.setURI("#" + samlAssertion.getId());
                if (samlAssertion.getSaml1() != null) {
                    ref.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                    secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                } else if (samlAssertion.getSaml2() != null) {
                    secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                }
                secRef.setReference(ref);
            } else {
                keyId = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
                valueType = null;
                if (samlAssertion.getSaml1() != null) {
                    valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                    secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                } else if (samlAssertion.getSaml2() != null) {
                    valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
                    secRef.addTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                }
                keyId.setAttributeNS(null, "ValueType", valueType);
                keyId.appendChild(doc.createTextNode(samlAssertion.getId()));
                elem = secRef.getElement();
                elem.appendChild(keyId);
            }
        }
        DOMStructure structure = new DOMStructure(secRef.getElement());
        this.wsDocInfo.addTokenElement(secRef.getElement(), false);
        KeyInfoFactory keyInfoFactory = this.signatureFactory.getKeyInfoFactory();
        this.keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(structure), this.keyInfoUri);
        this.wsDocInfo.addTokenElement(this.samlToken, false);
    }

    public void prependSAMLElementsToHeader(WSSecHeader secHeader) {
        if (this.senderVouches) {
            WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.secRefSaml.getElement());
        }
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.samlToken);
    }

    public void computeSignature(List<Reference> referenceList, WSSecHeader secHeader, Element siblingElement) throws WSSecurityException {
        try {
            Key key = this.senderVouches ? this.issuerCrypto.getPrivateKey(this.issuerKeyName, this.issuerKeyPW) : (this.secretKey != null ? KeyUtils.prepareSecretKey((String)this.getSignatureAlgorithm(), (byte[])this.secretKey) : this.userCrypto.getPrivateKey(this.user, this.password));
            SignatureMethod signatureMethod = this.signatureFactory.newSignatureMethod(this.getSignatureAlgorithm(), null);
            SignedInfo signedInfo = this.signatureFactory.newSignedInfo(this.c14nMethod, signatureMethod, referenceList);
            this.sig = this.signatureFactory.newXMLSignature(signedInfo, this.keyInfo, null, this.getIdAllocator().createId("SIG-", null), null);
            Element securityHeaderElement = secHeader.getSecurityHeader();
            DOMSignContext signContext = null;
            signContext = siblingElement != null && siblingElement.getNextSibling() != null ? new DOMSignContext(key, (Node)securityHeaderElement, siblingElement.getNextSibling()) : new DOMSignContext(key, (Node)securityHeaderElement);
            signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.getSigCanonicalization())) {
                signContext.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
            }
            signContext.setProperty("transform_ws_doc_info", this.wsDocInfo);
            this.wsDocInfo.setCallbackLookup(this.callbackLookup);
            this.wsDocInfo.setTokensOnContext(signContext);
            this.sig.sign(signContext);
            this.signatureValue = this.sig.getSignatureValue().getValue();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, ex);
        }
    }

    public boolean isUseDirectReferenceToAssertion() {
        return this.useDirectReferenceToAssertion;
    }

    public void setUseDirectReferenceToAssertion(boolean useDirectReferenceToAssertion) {
        this.useDirectReferenceToAssertion = useDirectReferenceToAssertion;
    }
}

