/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.v1_8;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.codehaus.gmaven.feature.Component;
import org.codehaus.gmaven.feature.Feature;
import org.codehaus.gmaven.feature.support.FeatureSupport;
import org.codehaus.gmaven.runtime.StubCompiler;
import org.codehaus.gmaven.runtime.support.CompilerSupport;
import org.codehaus.gmaven.runtime.v1_8.JavaStubCompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;

public class StubCompilerFeature
extends FeatureSupport {
    public StubCompilerFeature() {
        super(StubCompiler.KEY);
    }

    protected Component doCreate() throws Exception {
        return new StubCompilerImpl();
    }

    StubCompilerImpl createInternal() throws Exception {
        return new StubCompilerImpl();
    }

    private class StubCompilerImpl
    extends CompilerSupport
    implements StubCompiler,
    StubCompiler.Keys {
        private CompilerConfiguration cc;

        private StubCompilerImpl() throws Exception {
            super((Feature)StubCompilerFeature.this);
            this.cc = new CompilerConfiguration();
        }

        private void configure() {
            if (this.config.contains("sourceEncoding")) {
                this.cc.setSourceEncoding(this.config.get("sourceEncoding", (String)null));
            }
        }

        public int compile() throws Exception {
            if (this.sources.isEmpty()) {
                this.log.debug("No sources added to compile; skipping");
                return 0;
            }
            HashMap<String, File> options = new HashMap<String, File>();
            options.put("stubDir", this.getTargetDirectory());
            this.cc.setJointCompilationOptions(options);
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            GroovyClassLoader gcl = new GroovyClassLoader(parent, this.cc);
            this.log.debug("Classpath:");
            URL[] classpath = this.getClassPath();
            for (int i = 0; i < classpath.length; ++i) {
                gcl.addURL(classpath[i]);
                this.log.debug("    {}", (Object)classpath[i]);
            }
            Object security = null;
            GroovyClassLoader transformLoader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            for (int i = 0; i < classpath.length; ++i) {
                transformLoader.addURL(classpath[i]);
            }
            JavaStubCompilationUnit cu = new JavaStubCompilationUnit(this.cc, gcl);
            this.log.debug("Compiling {} stubs for source(s)", (Object)this.sources.size());
            for (URL url : this.sources) {
                this.log.debug("    {}", (Object)url);
                cu.addSource(url);
            }
            this.configure();
            cu.compile();
            int count = cu.getStubCount();
            this.log.debug("Compiled {} stubs", (Object)String.valueOf(count));
            return count;
        }
    }
}

