/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.flatten.ElementHandling;
import org.codehaus.mojo.flatten.PomProperty;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlattenDescriptor {
    private final Map<String, ElementHandling> name2handlingMap = new HashMap<String, ElementHandling>();

    public FlattenDescriptor() {
    }

    public FlattenDescriptor(Xpp3Dom descriptor) {
        this();
        for (PomProperty<?> property : PomProperty.getPomProperties()) {
            String element = property.getName();
            if (descriptor.getChild(element) == null) continue;
            this.name2handlingMap.put(element, ElementHandling.expand);
        }
    }

    public ElementHandling getHandling(PomProperty<?> property) {
        ElementHandling handling = this.name2handlingMap.get(property.getName());
        if (handling == null) {
            handling = ElementHandling.flatten;
        }
        return handling;
    }

    public void setHandling(PomProperty<?> property, ElementHandling handling) {
        this.name2handlingMap.put(property.getName(), handling);
    }

    public ElementHandling getName() {
        return this.getHandling(PomProperty.NAME);
    }

    public void setName(ElementHandling name) {
        this.setHandling(PomProperty.NAME, name);
    }

    public ElementHandling getDescription() {
        return this.getHandling(PomProperty.DESCRIPTION);
    }

    public void setDescription(ElementHandling description) {
        this.setHandling(PomProperty.DESCRIPTION, description);
    }

    public ElementHandling getUrl() {
        return this.getHandling(PomProperty.URL);
    }

    public void setUrl(ElementHandling url) {
        this.setHandling(PomProperty.URL, url);
    }

    public ElementHandling getInceptionYear() {
        return this.getHandling(PomProperty.INCEPTION_YEAR);
    }

    public void setInceptionYear(ElementHandling inceptionYear) {
        this.setHandling(PomProperty.INCEPTION_YEAR, inceptionYear);
    }

    public ElementHandling getOrganization() {
        return this.getHandling(PomProperty.ORGANIZATION);
    }

    public void setOrganization(ElementHandling organization) {
        this.setHandling(PomProperty.ORGANIZATION, organization);
    }

    public ElementHandling getScm() {
        return this.getHandling(PomProperty.SCM);
    }

    public void setScm(ElementHandling scm) {
        this.setHandling(PomProperty.SCM, scm);
    }

    public ElementHandling getPrerequisites() {
        return this.getHandling(PomProperty.PREREQUISITES);
    }

    public void setPrerequisites(ElementHandling prerequisites) {
        this.setHandling(PomProperty.PREREQUISITES, prerequisites);
    }

    public ElementHandling getDevelopers() {
        return this.getHandling(PomProperty.DEVELOPERS);
    }

    public void setDevelopers(ElementHandling developers) {
        this.setHandling(PomProperty.DEVELOPERS, developers);
    }

    public ElementHandling getContributors() {
        return this.getHandling(PomProperty.CONTRIBUTORS);
    }

    public void setContributors(ElementHandling contributors) {
        this.setHandling(PomProperty.CONTRIBUTORS, contributors);
    }

    public ElementHandling getMailingLists() {
        return this.getHandling(PomProperty.MAILING_LISTS);
    }

    public void setMailingLists(ElementHandling mailingLists) {
        this.setHandling(PomProperty.MAILING_LISTS, mailingLists);
    }

    public ElementHandling getRepositories() {
        return this.getHandling(PomProperty.REPOSITORIES);
    }

    public void setRepositories(ElementHandling repositories) {
        this.setHandling(PomProperty.REPOSITORIES, repositories);
    }

    public ElementHandling getPluginManagement() {
        return this.getHandling(PomProperty.PLUGIN_MANAGEMENT);
    }

    public void setPluginManagement(ElementHandling pluginManagement) {
        this.setHandling(PomProperty.PLUGIN_MANAGEMENT, pluginManagement);
    }

    public ElementHandling getPluginRepositories() {
        return this.getHandling(PomProperty.PLUGIN_REPOSITORIES);
    }

    public void setPluginRepositories(ElementHandling pluginRepositories) {
        this.setHandling(PomProperty.PLUGIN_REPOSITORIES, pluginRepositories);
    }

    public ElementHandling getIssueManagement() {
        return this.getHandling(PomProperty.ISSUE_MANAGEMENT);
    }

    public void setIssueManagement(ElementHandling issueManagement) {
        this.setHandling(PomProperty.ISSUE_MANAGEMENT, issueManagement);
    }

    public ElementHandling getCiManagement() {
        return this.getHandling(PomProperty.CI_MANAGEMENT);
    }

    public void setCiManagement(ElementHandling ciManagement) {
        this.setHandling(PomProperty.CI_MANAGEMENT, ciManagement);
    }

    public ElementHandling getDistributionManagement() {
        return this.getHandling(PomProperty.DISTRIBUTION_MANAGEMENT);
    }

    public void setDistributionManagement(ElementHandling distributionManagement) {
        this.setHandling(PomProperty.DISTRIBUTION_MANAGEMENT, distributionManagement);
    }

    public ElementHandling getDependencyManagement() {
        return this.getHandling(PomProperty.DEPENDENCY_MANAGEMENT);
    }

    public void setDependencyManagement(ElementHandling dependencyManagement) {
        this.setHandling(PomProperty.DEPENDENCY_MANAGEMENT, dependencyManagement);
    }

    public ElementHandling getBuild() {
        return this.getHandling(PomProperty.BUILD);
    }

    public void setBuild(ElementHandling build) {
        this.setHandling(PomProperty.BUILD, build);
    }

    public ElementHandling getParent() {
        return this.getHandling(PomProperty.PARENT);
    }

    public void setParent(ElementHandling parent) {
        this.setHandling(PomProperty.PARENT, parent);
    }

    public ElementHandling getModules() {
        return this.getHandling(PomProperty.MODULES);
    }

    public void setModules(ElementHandling modules) {
        this.setHandling(PomProperty.MODULES, modules);
    }

    public ElementHandling getProperties() {
        return this.getHandling(PomProperty.PROPERTIES);
    }

    public void setProperties(ElementHandling properties) {
        this.setHandling(PomProperty.PROPERTIES, properties);
    }

    public ElementHandling getReporting() {
        return this.getHandling(PomProperty.REPORTING);
    }

    public void setReporting(ElementHandling reporting) {
        this.setHandling(PomProperty.REPORTING, reporting);
    }

    public ElementHandling getDependencies() {
        return this.getHandling(PomProperty.DEPENDENCIES);
    }

    public void setDependencies(ElementHandling dependencies) {
        this.setHandling(PomProperty.DEPENDENCIES, dependencies);
    }

    public ElementHandling getProfiles() {
        return this.getHandling(PomProperty.PROFILES);
    }

    public void setProfiles(ElementHandling profiles) {
        this.setHandling(PomProperty.PROFILES, profiles);
    }

    public ElementHandling getVersion() {
        return this.getHandling(PomProperty.VERSION);
    }

    public void setVersion(ElementHandling version) {
        this.setHandling(PomProperty.VERSION, version);
    }

    public FlattenDescriptor merge(FlattenDescriptor descriptor) {
        FlattenDescriptor result = new FlattenDescriptor();
        for (PomProperty<?> property : PomProperty.getPomProperties()) {
            String name = property.getName();
            ElementHandling handling = this.name2handlingMap.get(name);
            if (handling == null) {
                handling = descriptor.name2handlingMap.get(name);
            }
            if (handling == null) continue;
            result.name2handlingMap.put(name, handling);
        }
        return result;
    }

    public boolean isEmpty() {
        for (ElementHandling handling : this.name2handlingMap.values()) {
            if (handling == null) continue;
            return false;
        }
        return true;
    }
}

