package org.codehaus.plexus.components.interactivity;

/*
 * The MIT License
 *
 * Copyright (c) 2005, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import java.util.List;

/**
 * Prompt the user for input.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: Prompter.java 2649 2005-10-10 16:51:51Z brett $
 */
public interface Prompter
{
    String ROLE = Prompter.class.getName();

    String prompt( String message )
        throws PrompterException;

    String prompt( String message, String defaultReply )
        throws PrompterException;

    String prompt( String message, List possibleValues )
        throws PrompterException;

    String prompt( String message, List possibleValues, String defaultReply )
        throws PrompterException;

    String promptForPassword( String message )
        throws PrompterException;

    void showMessage( String message )
        throws PrompterException;
}
