/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion JAVA_SPECIFICATION_VERSION = JavaVersion.parse(System.getProperty("java.specification.version"));
    public static final JavaVersion JAVA_VERSION = JavaVersion.parse(System.getProperty("java.version"));
    private static final Pattern startingDigits = Pattern.compile("(\\d+)(.*)");
    private String rawVersion;

    private JavaVersion(String rawVersion) {
        this.rawVersion = rawVersion;
    }

    public static JavaVersion parse(String s) {
        return new JavaVersion(s);
    }

    @Override
    public int compareTo(JavaVersion other) {
        String[] thisSegments = this.rawVersion.split("\\.");
        String[] otherSegments = other.rawVersion.split("\\.");
        int minSegments = Math.min(thisSegments.length, otherSegments.length);
        for (int index = 0; index < minSegments; ++index) {
            Matcher otherMatcher;
            int otherValue;
            Matcher thisMatcher = startingDigits.matcher(thisSegments[index]);
            int thisValue = thisMatcher.find() ? Integer.parseInt(thisMatcher.group(1)) : -1;
            int compareValue = Integer.compare(thisValue, otherValue = (otherMatcher = startingDigits.matcher(otherSegments[index])).find() ? Integer.parseInt(otherMatcher.group(1)) : -1);
            if (compareValue != 0) {
                return compareValue;
            }
            compareValue = this.suffixRate(thisMatcher.group(2)) - this.suffixRate(otherMatcher.group(2));
            if (compareValue != 0) {
                return compareValue;
            }
            compareValue = thisMatcher.group(2).compareTo(otherMatcher.group(2));
            if (compareValue == 0) continue;
            return compareValue;
        }
        return thisSegments.length - otherSegments.length;
    }

    private int suffixRate(String suffix) {
        if ("-ea".equals(suffix)) {
            return -100;
        }
        if ("".equals(suffix)) {
            return 0;
        }
        return 10;
    }

    public boolean isBefore(JavaVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isBefore(String other) {
        return this.compareTo(JavaVersion.parse(other)) < 0;
    }

    public boolean isAtLeast(JavaVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isAtLeast(String other) {
        return this.compareTo(JavaVersion.parse(other)) >= 0;
    }

    public String toString() {
        return this.rawVersion;
    }
}

