/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.home.cache;

import java.io.File;
import javax.annotation.Nullable;
import org.sonar.runner.commonsio.FileUtils;
import org.sonar.runner.home.cache.FileCache;
import org.sonar.runner.home.log.Log;
import org.sonar.runner.home.log.StandardLog;

public class FileCacheBuilder {
    private File userHome;
    private Log log = new StandardLog();

    public FileCacheBuilder setUserHome(File d) {
        this.userHome = d;
        return this;
    }

    public FileCacheBuilder setLog(Log log) {
        this.log = log;
        return this;
    }

    public FileCacheBuilder setUserHome(@Nullable String path) {
        this.userHome = path == null ? null : new File(path);
        return this;
    }

    public FileCache build() {
        if (this.userHome == null) {
            String path = System.getenv("SONAR_USER_HOME");
            if (path == null) {
                path = FileUtils.getUserDirectoryPath() + File.separator + ".sonar";
            }
            this.userHome = new File(path);
        }
        File cacheDir = new File(this.userHome, "cache");
        return FileCache.create(cacheDir, this.log);
    }
}

