/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.impl;

import java.io.File;
import java.util.List;
import org.sonar.runner.impl.JarExtractor;
import org.sonar.runner.impl.Jars;
import org.sonar.runner.impl.ServerConnection;
import org.sonar.runner.impl.ServerVersion;

class JarDownloader {
    private final ServerConnection serverConnection;
    private final ServerVersion serverVersion;

    JarDownloader(ServerConnection conn, ServerVersion version) {
        this.serverConnection = conn;
        this.serverVersion = version;
    }

    List<File> checkVersionAndDownload() {
        if (!this.serverVersion.is37Compatible()) {
            throw new IllegalStateException("SonarQube " + this.serverVersion.version() + " is not supported. Please upgrade SonarQube to version 3.7 or more.");
        }
        List<File> jarFiles = this.download();
        return jarFiles;
    }

    List<File> download() {
        return new Jars(this.serverConnection, new JarExtractor()).download();
    }
}

