/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;

public abstract class AbstractTokenizer
implements Tokenizer {
    protected List<String> stringToken;
    protected List<String> ignorableCharacter;
    protected List<String> ignorableStmt;
    protected char ONE_LINE_COMMENT_CHAR = (char)35;
    private List<String> code;
    private int lineNumber = 0;
    private String currentLine;
    protected boolean spanMultipleLinesString = true;
    private boolean downcaseString = true;

    public void tokenize(SourceCode tokens, Tokens tokenEntries) {
        this.code = tokens.getCode();
        this.lineNumber = 0;
        while (this.lineNumber < this.code.size()) {
            this.currentLine = this.code.get(this.lineNumber);
            int loc = 0;
            while (loc < this.currentLine.length()) {
                StringBuffer token = new StringBuffer();
                loc = this.getTokenFromLine(token, loc);
                if (token.length() <= 0 || this.isIgnorableString(token.toString()) || !this.downcaseString) continue;
                token = new StringBuffer(token.toString().toLowerCase());
            }
            ++this.lineNumber;
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private int getTokenFromLine(StringBuffer token, int loc) {
        int j = loc;
        while (j < this.currentLine.length()) {
            char tok = this.currentLine.charAt(j);
            if (!Character.isWhitespace(tok) && !this.ignoreCharacter(tok)) {
                if (this.isComment(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.getCommentToken(token, loc);
                }
                if (this.isString(tok)) {
                    if (token.length() > 0) {
                        return j;
                    }
                    return this.parseString(token, j, tok);
                }
                token.append(tok);
            } else if (token.length() > 0) {
                return j;
            }
            loc = j++;
        }
        return loc + 1;
    }

    private int parseString(StringBuffer token, int loc, char stringDelimiter) {
        boolean escaped = false;
        boolean done = false;
        char tok = ' ';
        while (loc < this.currentLine.length() && !done) {
            tok = this.currentLine.charAt(loc);
            if (escaped && tok == stringDelimiter) {
                escaped = false;
            } else if (tok == stringDelimiter && token.length() > 0) {
                done = true;
            } else {
                escaped = tok == '\\';
            }
            token.append(tok);
            ++loc;
        }
        if (!done && loc >= this.currentLine.length() && this.spanMultipleLinesString && ++this.lineNumber < this.code.size()) {
            this.currentLine = this.code.get(this.lineNumber);
            loc = this.parseString(token, loc, stringDelimiter);
        }
        return loc + 1;
    }

    private boolean ignoreCharacter(char tok) {
        return this.ignorableCharacter.contains("" + tok);
    }

    private boolean isString(char tok) {
        return this.stringToken.contains("" + tok);
    }

    private boolean isComment(char tok) {
        return tok == this.ONE_LINE_COMMENT_CHAR;
    }

    private int getCommentToken(StringBuffer token, int loc) {
        while (loc < this.currentLine.length()) {
            token.append(this.currentLine.charAt(loc++));
        }
        return loc;
    }

    private boolean isIgnorableString(String token) {
        return this.ignorableStmt.contains(token);
    }
}

