/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Date;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.DelegatedExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class TemporalExpression
extends SQLExpression {
    public TemporalExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public TemporalExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args) {
        super(stmt, mapping, functionName, args, null);
    }

    public TemporalExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args, List types) {
        super(stmt, mapping, functionName, args, types);
    }

    protected TemporalExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof ColumnExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    @Override
    public BooleanExpression in(SQLExpression expr, boolean not) {
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        SQLExpression delegate;
        if (expr instanceof TemporalExpression) {
            return new TemporalExpression(this, Expression.OP_ADD, expr).encloseInParentheses();
        }
        if (expr instanceof DelegatedExpression && (delegate = ((DelegatedExpression)expr).getDelegate()) instanceof TemporalExpression) {
            return new TemporalExpression(this, Expression.OP_ADD, delegate).encloseInParentheses();
        }
        return super.add(expr);
    }

    @Override
    public SQLExpression sub(SQLExpression expr) {
        SQLExpression delegate;
        if (expr instanceof TemporalExpression) {
            return new TemporalExpression(this, Expression.OP_SUB, expr).encloseInParentheses();
        }
        if (expr instanceof DelegatedExpression && (delegate = ((DelegatedExpression)expr).getDelegate()) instanceof TemporalExpression) {
            return new TemporalExpression(this, Expression.OP_SUB, delegate).encloseInParentheses();
        }
        return super.sub(expr);
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Date.class.getName(), methodName, this, args);
    }
}

