/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.sernetcdf.SerNetCDFUtils;
import ucar.ma2.Array;
import ucar.nc2.dataset.NetcdfDataset;

public class EarthdataHDFPointMapper
implements FlatMapFunction<Iterator<String>, Geometry> {
    private int offset = 0;
    private int increment = 1;
    private String rootGroupName = "MOD_Swath_LST";
    private String geolocationField = "Geolocation_Fields";
    private String longitudeName = "Longitude";
    private String latitudeName = "Latitude";
    private String dataFieldName = "Data_Fields";
    private String dataVariableName = "LST";
    private String[] dataVariableList;
    private String longitudePath = "";
    private String latitudePath = "";
    private String dataPath = "";
    private String[] dataPathList;
    private boolean switchCoordinateXY = false;
    private String urlPrefix = "";

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, boolean switchCoordinateXY) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.switchCoordinateXY = switchCoordinateXY;
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, boolean switchCoordinateXY, String urlPrefix) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.switchCoordinateXY = switchCoordinateXY;
        this.urlPrefix = urlPrefix;
    }

    public EarthdataHDFPointMapper(int offset, int increment, String rootGroupName, String[] dataVariableList, String dataVariableName, String urlPrefix) {
        this.offset = offset;
        this.increment = increment;
        this.rootGroupName = rootGroupName;
        this.dataVariableList = dataVariableList;
        this.dataVariableName = dataVariableName;
        this.longitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.longitudeName;
        this.latitudePath = this.rootGroupName + "/" + this.geolocationField + "/" + this.latitudeName;
        this.dataPath = this.rootGroupName + "/" + this.dataFieldName + "/" + this.dataVariableName;
        this.dataPathList = new String[dataVariableList.length];
        for (int i = 0; i < dataVariableList.length; ++i) {
            this.dataPathList[i] = this.rootGroupName + "/" + this.dataFieldName + "/" + dataVariableList[i];
        }
        this.urlPrefix = urlPrefix;
    }

    public List<Geometry> call(Iterator<String> stringIterator) throws Exception {
        ArrayList<Geometry> hdfData = new ArrayList<Geometry>();
        while (stringIterator.hasNext()) {
            String hdfAddress = stringIterator.next();
            NetcdfDataset netcdfSet = SerNetCDFUtils.loadNetCDFDataSet((String)(this.urlPrefix + hdfAddress));
            Array longitudeArray = SerNetCDFUtils.getNetCDF2DArray((NetcdfDataset)netcdfSet, (String)this.longitudePath);
            Array latitudeArray = SerNetCDFUtils.getNetCDF2DArray((NetcdfDataset)netcdfSet, (String)this.latitudePath);
            Array dataArray = SerNetCDFUtils.getNetCDF2DArray((NetcdfDataset)netcdfSet, (String)this.dataPath);
            Array[] dataArrayList = new Array[this.dataVariableList.length];
            for (int i = 0; i < this.dataVariableList.length; ++i) {
                dataArrayList[i] = SerNetCDFUtils.getNetCDF2DArray((NetcdfDataset)netcdfSet, (String)this.dataPathList[i]);
            }
            int[] geolocationShape = longitudeArray.getShape();
            GeometryFactory geometryFactory = new GeometryFactory();
            for (int j = 0; j < geolocationShape[0]; ++j) {
                for (int i = 0; i < geolocationShape[1]; ++i) {
                    Coordinate coordinate = null;
                    coordinate = this.switchCoordinateXY ? new Coordinate(SerNetCDFUtils.getDataSym((Array)longitudeArray, (int)j, (int)i), SerNetCDFUtils.getDataSym((Array)latitudeArray, (int)j, (int)i), SerNetCDFUtils.getDataAsym((Array)dataArray, (int)j, (int)i, (int)this.offset, (int)this.increment)) : new Coordinate(SerNetCDFUtils.getDataSym((Array)latitudeArray, (int)j, (int)i), SerNetCDFUtils.getDataSym((Array)longitudeArray, (int)j, (int)i), SerNetCDFUtils.getDataAsym((Array)dataArray, (int)j, (int)i, (int)this.offset, (int)this.increment));
                    Point observation = geometryFactory.createPoint(coordinate);
                    String userData = "";
                    for (int k = 0; k < this.dataVariableList.length - 1; ++k) {
                        userData = userData + SerNetCDFUtils.getDataAsym((Array)dataArrayList[k], (int)j, (int)i, (int)this.offset, (int)this.increment) + " ";
                    }
                    userData = userData + SerNetCDFUtils.getDataAsym((Array)dataArrayList[this.dataVariableList.length - 1], (int)j, (int)i, (int)this.offset, (int)this.increment);
                    observation.setUserData(userData);
                    hdfData.add(observation);
                }
            }
        }
        return hdfData;
    }
}

