/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.datasyslab.geospark.enums.FileDataSplitter;
import org.datasyslab.geospark.formatMapper.FormatMapper;
import org.wololo.geojson.Feature;
import org.wololo.geojson.GeoJSONFactory;
import org.wololo.jts2geojson.GeoJSONReader;

public class RectangleFormatMapper
extends FormatMapper
implements FlatMapFunction<Iterator<String>, Object> {
    public RectangleFormatMapper(FileDataSplitter Splitter, boolean carryInputData) {
        super(Splitter, carryInputData);
    }

    public RectangleFormatMapper(Integer startOffset, Integer endOffset, FileDataSplitter Splitter, boolean carryInputData) {
        super(startOffset, endOffset, Splitter, carryInputData);
    }

    public List<Object> call(Iterator<String> stringIterator) throws Exception {
        MultiPolygon multiSpatialObjects = null;
        ArrayList<Object> result = new ArrayList<Object>();
        block8: while (stringIterator.hasNext()) {
            String line = stringIterator.next();
            try {
                switch (this.splitter) {
                    case CSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        Double x1 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset));
                        Double x2 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 2));
                        Double y1 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 1));
                        Double y2 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 3));
                        this.coordinates = new Coordinate[5];
                        this.coordinates[0] = new Coordinate(x1, y1);
                        this.coordinates[1] = new Coordinate(x1, y2);
                        this.coordinates[2] = new Coordinate(x2, y2);
                        this.coordinates[3] = new Coordinate(x2, y1);
                        this.coordinates[4] = this.coordinates[0];
                        LinearRing linear = this.fact.createLinearRing(this.coordinates);
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add(this.spatialObject);
                        break;
                    }
                    case TSV: {
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        Double x1 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset));
                        Double x2 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 2));
                        Double y1 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 1));
                        Double y2 = Double.parseDouble((String)this.lineSplitList.get(this.startOffset + 3));
                        this.coordinates = new Coordinate[5];
                        this.coordinates[0] = new Coordinate(x1, y1);
                        this.coordinates[1] = new Coordinate(x1, y2);
                        this.coordinates[2] = new Coordinate(x2, y2);
                        this.coordinates[3] = new Coordinate(x2, y1);
                        this.coordinates[4] = this.coordinates[0];
                        LinearRing linear = this.fact.createLinearRing(this.coordinates);
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add(this.spatialObject);
                        break;
                    }
                    case GEOJSON: {
                        LinearRing linear;
                        Double y2;
                        Double y1;
                        Double x2;
                        Double x1;
                        GeoJSONReader reader = new GeoJSONReader();
                        this.spatialObject = reader.read(line);
                        if (line.contains("Feature")) {
                            Feature feature = (Feature)GeoJSONFactory.create(line);
                            this.spatialObject = reader.read(feature.getGeometry());
                        } else {
                            this.spatialObject = reader.read(line);
                        }
                        if (this.spatialObject instanceof MultiPolygon) {
                            multiSpatialObjects = (MultiPolygon)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                x1 = this.spatialObject.getEnvelopeInternal().getMinX();
                                x2 = this.spatialObject.getEnvelopeInternal().getMaxX();
                                y1 = this.spatialObject.getEnvelopeInternal().getMinY();
                                y2 = this.spatialObject.getEnvelopeInternal().getMaxY();
                                this.coordinates = new Coordinate[5];
                                this.coordinates[0] = new Coordinate(x1, y1);
                                this.coordinates[1] = new Coordinate(x1, y2);
                                this.coordinates[2] = new Coordinate(x2, y2);
                                this.coordinates[3] = new Coordinate(x2, y1);
                                this.coordinates[4] = this.coordinates[0];
                                linear = this.fact.createLinearRing(this.coordinates);
                                this.spatialObject = new Polygon(linear, null, this.fact);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add(this.spatialObject);
                            }
                            continue block8;
                        }
                        x1 = this.spatialObject.getEnvelopeInternal().getMinX();
                        x2 = this.spatialObject.getEnvelopeInternal().getMaxX();
                        y1 = this.spatialObject.getEnvelopeInternal().getMinY();
                        y2 = this.spatialObject.getEnvelopeInternal().getMaxY();
                        this.coordinates = new Coordinate[5];
                        this.coordinates[0] = new Coordinate(x1, y1);
                        this.coordinates[1] = new Coordinate(x1, y2);
                        this.coordinates[2] = new Coordinate(x2, y2);
                        this.coordinates[3] = new Coordinate(x2, y1);
                        this.coordinates[4] = this.coordinates[0];
                        linear = this.fact.createLinearRing(this.coordinates);
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add(this.spatialObject);
                        break;
                    }
                    case WKT: {
                        LinearRing linear;
                        Double y2;
                        Double y1;
                        Double x2;
                        Double x1;
                        this.lineSplitList = Arrays.asList(line.split(this.splitter.getDelimiter()));
                        WKTReader wktreader = new WKTReader();
                        this.spatialObject = wktreader.read((String)this.lineSplitList.get(this.startOffset));
                        if (this.spatialObject instanceof MultiPolygon) {
                            multiSpatialObjects = (MultiPolygon)this.spatialObject;
                            for (int i = 0; i < multiSpatialObjects.getNumGeometries(); ++i) {
                                this.spatialObject = multiSpatialObjects.getGeometryN(i);
                                x1 = this.spatialObject.getEnvelopeInternal().getMinX();
                                x2 = this.spatialObject.getEnvelopeInternal().getMaxX();
                                y1 = this.spatialObject.getEnvelopeInternal().getMinY();
                                y2 = this.spatialObject.getEnvelopeInternal().getMaxY();
                                this.coordinates = new Coordinate[5];
                                this.coordinates[0] = new Coordinate(x1, y1);
                                this.coordinates[1] = new Coordinate(x1, y2);
                                this.coordinates[2] = new Coordinate(x2, y2);
                                this.coordinates[3] = new Coordinate(x2, y1);
                                this.coordinates[4] = this.coordinates[0];
                                linear = this.fact.createLinearRing(this.coordinates);
                                this.spatialObject = new Polygon(linear, null, this.fact);
                                if (this.carryInputData) {
                                    this.spatialObject.setUserData(line);
                                }
                                result.add(this.spatialObject);
                            }
                            continue block8;
                        }
                        x1 = this.spatialObject.getEnvelopeInternal().getMinX();
                        x2 = this.spatialObject.getEnvelopeInternal().getMaxX();
                        y1 = this.spatialObject.getEnvelopeInternal().getMinY();
                        y2 = this.spatialObject.getEnvelopeInternal().getMaxY();
                        this.coordinates = new Coordinate[5];
                        this.coordinates[0] = new Coordinate(x1, y1);
                        this.coordinates[1] = new Coordinate(x1, y2);
                        this.coordinates[2] = new Coordinate(x2, y2);
                        this.coordinates[3] = new Coordinate(x2, y1);
                        this.coordinates[4] = this.coordinates[0];
                        linear = this.fact.createLinearRing(this.coordinates);
                        this.spatialObject = new Polygon(linear, null, this.fact);
                        if (this.carryInputData) {
                            this.spatialObject.setUserData(line);
                        }
                        result.add(this.spatialObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

