/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShpParseUtil;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;

public class PolygonParser
extends ShapeParser {
    public PolygonParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    @Override
    public Geometry parserShape(ShapeReader reader) throws IOException {
        reader.skip(32);
        int numRings = reader.readInt();
        int numPoints = reader.readInt();
        int[] ringsOffsets = new int[numRings + 1];
        for (int i = 0; i < numRings; ++i) {
            ringsOffsets[i] = reader.readInt();
        }
        ringsOffsets[numRings] = numPoints;
        CoordinateSequence coordinateSequence = ShpParseUtil.readCoordinates(reader, numPoints, this.geometryFactory);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        for (int i = 0; i < numRings; ++i) {
            int readScale = ringsOffsets[i + 1] - ringsOffsets[i];
            CoordinateSequence csRing = this.geometryFactory.getCoordinateSequenceFactory().create(readScale, 2);
            for (int j = 0; j < readScale; ++j) {
                csRing.setOrdinate(j, 0, coordinateSequence.getOrdinate(ringsOffsets[i] + j, 0));
                csRing.setOrdinate(j, 1, coordinateSequence.getOrdinate(ringsOffsets[i] + j, 1));
            }
            if (csRing.size() < 3) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(csRing);
            if (CoordinateSequences.isCCW(csRing)) {
                holes.add(ring);
                continue;
            }
            shells.add(ring);
        }
        Polygon[] polygons = null;
        if (shells.size() == 1) {
            polygons = new Polygon[]{this.geometryFactory.createPolygon((LinearRing)shells.get(0), GeometryFactory.toLinearRingArray(holes))};
        } else if (shells.size() == 0 && holes.size() == 1) {
            polygons = new Polygon[]{this.geometryFactory.createPolygon((LinearRing)holes.get(0))};
        } else {
            ArrayList holesWithinShells = new ArrayList();
            for (int i = 0; i < shells.size(); ++i) {
                holesWithinShells.add(new ArrayList());
            }
            Iterator i = holes.iterator();
            while (i.hasNext()) {
                LinearRing hole;
                LinearRing testRing = hole = (LinearRing)i.next();
                Geometry minShell = null;
                Envelope minEnv = null;
                Envelope testEnv = testRing.getEnvelopeInternal();
                Coordinate testPt = testRing.getCoordinateN(0);
                Iterator iterator = shells.iterator();
                while (iterator.hasNext()) {
                    LinearRing shell;
                    LinearRing tryRing = shell = (LinearRing)iterator.next();
                    Envelope tryEnv = tryRing.getEnvelopeInternal();
                    if (minShell != null) {
                        minEnv = minShell.getEnvelopeInternal();
                    }
                    boolean isContained = false;
                    Coordinate[] coordList = tryRing.getCoordinates();
                    if (tryEnv.contains(testEnv) && (CGAlgorithms.isPointInRing(testPt, coordList) || ShpParseUtil.pointInList(testPt, coordList))) {
                        isContained = true;
                    }
                    if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                    minShell = tryRing;
                }
                if (minShell == null) {
                    shells.add(hole);
                    holesWithinShells.add(new ArrayList());
                    continue;
                }
                ((ArrayList)holesWithinShells.get(shells.indexOf(minShell))).add(hole);
            }
            polygons = new Polygon[shells.size()];
            for (int i2 = 0; i2 < shells.size(); ++i2) {
                polygons[i2] = this.geometryFactory.createPolygon((LinearRing)shells.get(i2), GeometryFactory.toLinearRingArray((Collection)holesWithinShells.get(i2)));
            }
        }
        return this.geometryFactory.createMultiPolygon(polygons);
    }
}

