/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.EndianUtils;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.DataInputStreamReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeFileConst;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShapeReader;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShpRecord;

public class ShpFileParser
implements Serializable,
ShapeFileConst {
    public int currentTokenType = 0;
    public long fileLength = 0L;
    public long remainLength = 0L;
    ShapeReader reader = null;

    public ShpFileParser(DataInputStream inputStream) {
        this.reader = new DataInputStreamReader(inputStream);
    }

    public void parseShapeFileHead() throws IOException {
        int fileCode = this.reader.readInt();
        this.reader.skip(20);
        this.remainLength = this.fileLength = (long)(16 * this.reader.readInt() - 800);
        int fileVersion = EndianUtils.swapInteger((int)this.reader.readInt());
        this.currentTokenType = EndianUtils.swapInteger((int)this.reader.readInt());
        this.reader.skip(64);
    }

    public ShpRecord parseRecordPrimitiveContent() throws IOException {
        int contentLength = this.reader.readInt();
        long recordLength = 16 * (contentLength + 4);
        this.remainLength -= recordLength;
        int typeID = EndianUtils.swapInteger((int)this.reader.readInt());
        byte[] contentArray = new byte[contentLength * 2 - 4];
        this.reader.read(contentArray, 0, contentArray.length);
        return new ShpRecord(contentArray, typeID);
    }

    public int parseRecordHeadID() throws IOException {
        int id = this.reader.readInt();
        return id;
    }

    public float getProgress() {
        return 1.0f - (float)this.remainLength / (float)this.fileLength;
    }
}

