/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.formatMapper.shapefileParser.shapes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.datasyslab.geospark.formatMapper.shapefileParser.parseUtils.shp.ShpFileParser;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShapeKey;
import org.datasyslab.geospark.formatMapper.shapefileParser.shapes.ShpRecord;

public class ShapeFileReader
extends RecordReader<ShapeKey, ShpRecord> {
    private ShapeKey recordKey = null;
    private ShpRecord recordContent = null;
    private FSDataInputStream shpInputStream = null;
    ShpFileParser parser = null;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        Path filePath = fileSplit.getPath();
        FileSystem fileSys = filePath.getFileSystem(context.getConfiguration());
        this.shpInputStream = fileSys.open(filePath);
        this.parser = new ShpFileParser((DataInputStream)this.shpInputStream);
        this.parser.parseShapeFileHead();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.getProgress() >= 1.0f) {
            return false;
        }
        this.recordKey = new ShapeKey();
        this.recordKey.setIndex(this.parser.parseRecordHeadID());
        this.recordContent = this.parser.parseRecordPrimitiveContent();
        return true;
    }

    public ShapeKey getCurrentKey() throws IOException, InterruptedException {
        return this.recordKey;
    }

    public ShpRecord getCurrentValue() throws IOException, InterruptedException {
        return this.recordContent;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.parser.getProgress();
    }

    public void close() throws IOException {
        this.shpInputStream.close();
    }
}

