/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HilbertPartitioning
implements Serializable {
    protected int[] splits;
    List<Envelope> grids = new ArrayList<Envelope>();

    public HilbertPartitioning(List SampleList, Envelope boundary, int partitions) throws Exception {
        int y;
        int x;
        int i;
        int gridResolution = Short.MAX_VALUE;
        int[] hValues = new int[SampleList.size()];
        Envelope[] gridWithoutID = new Envelope[partitions];
        if (SampleList.get(0) instanceof Envelope) {
            for (i = 0; i < SampleList.size(); ++i) {
                Envelope spatialObject = (Envelope)SampleList.get(i);
                x = HilbertPartitioning.locationMapping(boundary.getMinX(), boundary.getMaxX(), (spatialObject.getMinX() + spatialObject.getMaxX()) / 2.0);
                y = HilbertPartitioning.locationMapping(boundary.getMinY(), boundary.getMaxY(), (spatialObject.getMinY() + spatialObject.getMaxY()) / 2.0);
                hValues[i] = HilbertPartitioning.computeHValue(gridResolution + 1, x, y);
            }
        } else if (SampleList.get(0) instanceof Geometry) {
            for (i = 0; i < SampleList.size(); ++i) {
                Envelope envelope = ((Geometry)SampleList.get(i)).getEnvelopeInternal();
                x = HilbertPartitioning.locationMapping(boundary.getMinX(), boundary.getMaxX(), (envelope.getMinX() + envelope.getMaxX()) / 2.0);
                y = HilbertPartitioning.locationMapping(boundary.getMinY(), boundary.getMaxY(), (envelope.getMinY() + envelope.getMaxY()) / 2.0);
                hValues[i] = HilbertPartitioning.computeHValue(gridResolution + 1, x, y);
            }
        } else {
            throw new Exception("[HilbertPartitioning][Constrcutor] Unsupported spatial object type");
        }
        this.createFromHValues(hValues, partitions);
        for (i = 0; i < SampleList.size(); ++i) {
            Envelope initialBoundary = null;
            Object spatialObject = SampleList.get(i);
            if (SampleList.get(0) instanceof Envelope) {
                initialBoundary = (Envelope)spatialObject;
            } else if (SampleList.get(0) instanceof Geometry) {
                initialBoundary = ((Geometry)spatialObject).getEnvelopeInternal();
            } else {
                throw new Exception("[HilbertPartitioning][Constrcutor] Unsupported spatial object type");
            }
            int partitionID = HilbertPartitioning.gridID(boundary, SampleList.get(i), this.splits);
            gridWithoutID[partitionID] = initialBoundary;
        }
        for (i = 0; i < SampleList.size(); ++i) {
            int partitionID = HilbertPartitioning.gridID(boundary, SampleList.get(i), this.splits);
            gridWithoutID[partitionID] = HilbertPartitioning.updateEnvelope(gridWithoutID[partitionID], SampleList.get(i));
        }
        for (i = 0; i < gridWithoutID.length; ++i) {
            this.grids.add(gridWithoutID[i]);
        }
    }

    protected void createFromHValues(int[] hValues, int partitions) {
        Arrays.sort(hValues);
        this.splits = new int[partitions];
        int maxH = Integer.MAX_VALUE;
        for (int i = 0; i < this.splits.length; ++i) {
            int quantile = (int)((long)(i + 1) * (long)hValues.length / (long)partitions);
            this.splits[i] = quantile == hValues.length ? maxH : hValues[quantile];
        }
    }

    public static int computeHValue(int n, int x, int y) {
        int h = 0;
        for (int s = n / 2; s > 0; s /= 2) {
            int rx = (x & s) > 0 ? 1 : 0;
            int ry = (y & s) > 0 ? 1 : 0;
            h += s * s * (3 * rx ^ ry);
            if (ry != 0) continue;
            if (rx == 1) {
                x = n - 1 - x;
                y = n - 1 - y;
            }
            int t = x;
            x = y;
            y = t;
        }
        return h;
    }

    public int[] getPartitionBounds() {
        return this.splits;
    }

    public static int locationMapping(double axisMin, double axisLocation, double axisMax) {
        int gridResolution = Short.MAX_VALUE;
        Double gridLocation = (axisLocation - axisMin) * (double)gridResolution / (axisMax - axisMin);
        return gridLocation.intValue();
    }

    public static int gridID(Envelope boundary, Object spatialObject, int[] partitionBounds) throws Exception {
        int x = 0;
        int y = 0;
        if (spatialObject instanceof Envelope) {
            x = HilbertPartitioning.locationMapping(boundary.getMinX(), boundary.getMaxX(), (((Envelope)spatialObject).getMinX() + ((Envelope)spatialObject).getMaxX()) / 2.0);
            y = HilbertPartitioning.locationMapping(boundary.getMinY(), boundary.getMaxY(), (((Envelope)spatialObject).getMinY() + ((Envelope)spatialObject).getMaxY()) / 2.0);
        } else if (spatialObject instanceof Geometry) {
            Envelope envelope = ((Geometry)spatialObject).getEnvelopeInternal();
            x = HilbertPartitioning.locationMapping(boundary.getMinX(), boundary.getMaxX(), (envelope.getMinX() + envelope.getMaxX()) / 2.0);
            y = HilbertPartitioning.locationMapping(boundary.getMinY(), boundary.getMaxY(), (envelope.getMinY() + envelope.getMaxY()) / 2.0);
        } else {
            throw new Exception("[HilbertPartitioning][gridID] Unsupported spatial object type");
        }
        int gridResolution = Short.MAX_VALUE;
        int hValue = HilbertPartitioning.computeHValue(gridResolution + 1, x, y);
        int partition = Arrays.binarySearch(partitionBounds, hValue);
        if (partition < 0) {
            partition = -partition - 1;
        }
        return partition;
    }

    public static Envelope updateEnvelope(Envelope envelope, Object spatialObject) throws Exception {
        double minX = envelope.getMinX();
        double maxX = envelope.getMaxX();
        double minY = envelope.getMinY();
        double maxY = envelope.getMaxY();
        if (spatialObject instanceof Envelope) {
            Envelope i = (Envelope)spatialObject;
            if (minX > i.getMinX()) {
                minX = i.getMinX();
            }
            if (maxX < i.getMaxX()) {
                maxX = i.getMaxX();
            }
            if (minY > i.getMinY()) {
                minY = i.getMinY();
            }
            if (maxY < i.getMaxY()) {
                maxY = i.getMaxY();
            }
        } else if (spatialObject instanceof Geometry) {
            Envelope i = ((Geometry)spatialObject).getEnvelopeInternal();
            if (minX > i.getMinX()) {
                minX = i.getMinX();
            }
            if (maxX < i.getMaxX()) {
                maxX = i.getMaxX();
            }
            if (minY > i.getMinY()) {
                minY = i.getMinY();
            }
            if (maxY < i.getMaxY()) {
                maxY = i.getMaxY();
            }
        } else {
            throw new Exception("[HilbertPartitioning][updateEnvelope] Unsupported spatial object type");
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }
}

