/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.CoordinateSequences;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.BoundaryOp;

public class LineString
extends Geometry
implements Lineal {
    private static final long serialVersionUID = 3110669828065365560L;
    protected CoordinateSequence points;

    public LineString(Coordinate[] points, PrecisionModel precisionModel, int SRID) {
        super(new GeometryFactory(precisionModel, SRID));
        this.init(this.getFactory().getCoordinateSequenceFactory().create(points));
    }

    public LineString(CoordinateSequence points, GeometryFactory factory) {
        super(factory);
        this.init(points);
    }

    private void init(CoordinateSequence points) {
        if (points == null) {
            points = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        if (points.size() == 1) {
            throw new IllegalArgumentException("Invalid number of points in LineString (found " + points.size() + " - must be 0 or >= 2)");
        }
        this.points = points;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.points.toCoordinateArray();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n) {
        return this.points.getCoordinate(n);
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points.getCoordinate(0);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    public Point getPointN(int n) {
        return this.getFactory().createPoint(this.points.getCoordinate(n));
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    @Override
    public String getGeometryType() {
        return "LineString";
    }

    @Override
    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public Geometry reverse() {
        CoordinateSequence seq = (CoordinateSequence)this.points.clone();
        CoordinateSequences.reverse(seq);
        LineString revLine = this.getFactory().createLineString(seq);
        return revLine;
    }

    public boolean isCoordinate(Coordinate pt) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (!this.points.getCoordinate(i).equals(pt)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return this.points.expandEnvelope(new Envelope());
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        LineString otherLineString = (LineString)other;
        if (this.points.size() != otherLineString.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            if (this.equal(this.points.getCoordinate(i), otherLineString.points.getCoordinate(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        for (int i = 0; i < this.points.size(); ++i) {
            filter.filter(this.points.getCoordinate(i));
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.points.size() == 0) {
            return;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            filter.filter(this.points, i);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    @Override
    public Object clone() {
        LineString ls = (LineString)super.clone();
        ls.points = (CoordinateSequence)this.points.clone();
        return ls;
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.points.size() / 2; ++i) {
            int j = this.points.size() - 1 - i;
            if (this.points.getCoordinate(i).equals(this.points.getCoordinate(j))) continue;
            if (this.points.getCoordinate(i).compareTo(this.points.getCoordinate(j)) > 0) {
                CoordinateSequences.reverse(this.points);
            }
            return;
        }
    }

    @Override
    protected boolean isEquivalentClass(Geometry other) {
        return other instanceof LineString;
    }

    @Override
    protected int compareToSameClass(Object o) {
        int j;
        LineString line = (LineString)o;
        int i = 0;
        for (j = 0; i < this.points.size() && j < line.points.size(); ++i, ++j) {
            int comparison = this.points.getCoordinate(i).compareTo(line.points.getCoordinate(j));
            if (comparison == 0) continue;
            return comparison;
        }
        if (i < this.points.size()) {
            return 1;
        }
        if (j < line.points.size()) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        LineString line = (LineString)o;
        return comp.compare(this.points, line.points);
    }
}

