/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialPartitioning;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datasyslab.geospark.spatialPartitioning.quadtree.QuadRectangle;
import org.datasyslab.geospark.spatialPartitioning.quadtree.StandardQuadTree;
import scala.Tuple2;

public class PartitionJudgement
implements Serializable {
    public static Iterator<Tuple2<Integer, Object>> getPartitionID(List<Envelope> grids, Object spatialObject) throws Exception {
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        int overflowContainerID = grids.size();
        boolean containFlag = false;
        for (int gridId = 0; gridId < grids.size(); ++gridId) {
            if (grids.get(gridId).covers(((Geometry)spatialObject).getEnvelopeInternal())) {
                result.add(new Tuple2((Object)gridId, spatialObject));
                containFlag = true;
                continue;
            }
            if (!grids.get(gridId).intersects(((Geometry)spatialObject).getEnvelopeInternal()) && !((Geometry)spatialObject).getEnvelopeInternal().covers(grids.get(gridId))) continue;
            result.add(new Tuple2((Object)gridId, spatialObject));
        }
        if (!containFlag) {
            result.add(new Tuple2((Object)overflowContainerID, spatialObject));
        }
        return result.iterator();
    }

    public static Iterator<Tuple2<Integer, Object>> getPartitionID(StandardQuadTree partitionTree, Object spatialObject) throws Exception {
        HashSet<Tuple2> result = new HashSet<Tuple2>();
        boolean containFlag = false;
        ArrayList<QuadRectangle> matchedPartitions = new ArrayList<QuadRectangle>();
        try {
            partitionTree.getZone(matchedPartitions, new QuadRectangle(((Geometry)spatialObject).getEnvelopeInternal()));
        }
        catch (NullPointerException e) {
            return result.iterator();
        }
        for (int i = 0; i < matchedPartitions.size(); ++i) {
            containFlag = true;
            result.add(new Tuple2((Object)matchedPartitions.get((int)i).partitionId, spatialObject));
        }
        if (!containFlag) {
            // empty if block
        }
        return result.iterator();
    }
}

