/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Iterator;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;

public class MetaData
implements Iterable<HttpField> {
    private HttpVersion _httpVersion;
    private HttpFields _fields;
    long _contentLength = Long.MIN_VALUE;

    public MetaData() {
    }

    public MetaData(HttpVersion version, HttpFields fields) {
        this._httpVersion = version;
        this._fields = fields;
    }

    public MetaData(HttpVersion version, HttpFields fields, long contentLength) {
        this._httpVersion = version;
        this._fields = fields;
        this._contentLength = contentLength;
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    public HttpVersion getVersion() {
        return this._httpVersion;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this._httpVersion = httpVersion;
    }

    public HttpFields getFields() {
        return this._fields;
    }

    public void setFields(HttpFields fields) {
        this._fields = fields;
        this._contentLength = Long.MIN_VALUE;
    }

    public long getContentLength() {
        if (this._contentLength == Long.MIN_VALUE) {
            HttpField cl = this._fields.getField(HttpHeader.CONTENT_LENGTH);
            this._contentLength = cl == null ? -1L : cl.getLongValue();
        }
        return this._contentLength;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return this.getFields().iterator();
    }

    public int hashCode() {
        return 31 * this.getVersion().hashCode() + this.getFields().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaData)) {
            return false;
        }
        MetaData that = (MetaData)o;
        if (this.getVersion() != that.getVersion()) {
            return false;
        }
        return this.getFields().equals(that.getFields());
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (HttpField field : this) {
            out.append(field).append(System.lineSeparator());
        }
        return out.toString();
    }

    public static class Response
    extends MetaData {
        private int _status;
        private String _reason;

        public Response() {
        }

        public Response(HttpVersion version, int status, HttpFields fields) {
            this(version, status, fields, Long.MIN_VALUE);
        }

        public Response(HttpVersion version, int status, HttpFields fields, long contentLength) {
            super(version, fields, contentLength);
            this._status = status;
        }

        public Response(HttpVersion version, int status, String reason, HttpFields fields, long contentLength) {
            super(version, fields, contentLength);
            this._reason = reason;
            this._status = status;
        }

        @Override
        public boolean isResponse() {
            return true;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        public void setStatus(int status) {
            this._status = status;
        }

        public void setReason(String reason) {
            this._reason = reason;
        }

        @Override
        public int hashCode() {
            return 31 * this.getStatus() + super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response that = (Response)o;
            if (this.getStatus() != that.getStatus()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            return String.format("%s %d%s%s", new Object[]{this.getVersion(), this.getStatus(), System.lineSeparator(), super.toString()});
        }
    }

    public static class Request
    extends MetaData {
        private String _method;
        private HttpURI _uri;

        public Request() {
        }

        public Request(String method, HttpURI uri, HttpVersion version, HttpFields fields) {
            this(method, uri, version, fields, Long.MIN_VALUE);
        }

        public Request(String method, HttpURI uri, HttpVersion version, HttpFields fields, long contentLength) {
            super(version, fields, contentLength);
            this._method = method;
            this._uri = uri;
        }

        public Request(String method, HttpScheme scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields) {
            this(method, new HttpURI(scheme == null ? null : scheme.asString(), hostPort.getHost(), hostPort.getPort(), uri), version, fields);
        }

        public Request(String method, HttpScheme scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields, long contentLength) {
            this(method, new HttpURI(scheme == null ? null : scheme.asString(), hostPort.getHost(), hostPort.getPort(), uri), version, fields, contentLength);
        }

        public Request(String method, String scheme, HostPortHttpField hostPort, String uri, HttpVersion version, HttpFields fields, long contentLength) {
            this(method, new HttpURI(scheme, hostPort.getHost(), hostPort.getPort(), uri), version, fields, contentLength);
        }

        @Override
        public boolean isRequest() {
            return true;
        }

        public String getMethod() {
            return this._method;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public HttpURI getURI() {
            return this._uri;
        }

        public String getURIString() {
            return this._uri == null ? null : this._uri.toString();
        }

        public void setURI(HttpURI uri) {
            this._uri = uri;
        }

        @Override
        public int hashCode() {
            return (super.hashCode() * 31 + this._method.hashCode()) * 31 + this._uri.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request that = (Request)o;
            if (!this.getMethod().equals(that.getMethod()) || !this.getURI().equals(that.getURI())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            return String.format("%s %s %s%s%s", new Object[]{this.getMethod(), this.getURI(), this.getVersion(), System.lineSeparator(), super.toString()});
        }
    }
}

