/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.Dispatcher;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.FakeHttpServletRequest;
import org.geowebcache.layer.wms.FakeHttpServletResponse;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.util.ServletUtils;

public class WMSGeoServerHelper
extends WMSSourceHelper {
    private static Logger log = Logging.getLogger((String)WMSGeoServerHelper.class.toString());
    Dispatcher gsDispatcher;

    public WMSGeoServerHelper(Dispatcher gsDispatcher) {
        this.gsDispatcher = gsDispatcher;
    }

    protected byte[] makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, String wmsParams, String expectedMimeType) throws GeoWebCacheException {
        if (tileRespRecv instanceof ConveyorTile && ((ConveyorTile)tileRespRecv).getMimeType() == XMLMime.kml) {
            wmsParams = wmsParams.replaceAll("&format_options=.*&", "&");
            wmsParams = wmsParams.replaceAll("&format_options=.*$", "");
            wmsParams = wmsParams + "&format_options=" + ServletUtils.URLEncode((String)"regionateBy:auto");
        }
        FakeHttpServletRequest req = new FakeHttpServletRequest(wmsParams);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        try {
            this.gsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        }
        catch (Exception e) {
            log.fine(e.getMessage());
            throw new GeoWebCacheException("Problem communicating with GeoServer" + e.getMessage());
        }
        if (super.mimeStringCheck(expectedMimeType, resp.getContentType())) {
            int responseCode = resp.getResponseCode();
            tileRespRecv.setStatus(responseCode);
            if (responseCode == 200) {
                byte[] bytes = resp.getBytes();
                log.finer("Received " + bytes.length);
                return bytes;
            }
            if (responseCode == 204) {
                return new byte[0];
            }
            throw new GeoWebCacheException("Unexpected response from GeoServer for request " + wmsParams + ", got response code " + responseCode);
        }
        log.severe("Unexpected response from GeoServer for request: " + wmsParams);
        throw new GeoWebCacheException("Unexpected response from GeoServer for request " + wmsParams);
    }
}

