/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.gwc.GWC;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.map.RawMap;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.ConveyorTile;
import org.springframework.util.Assert;

public class CachingWebMapService
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CachingWebMapService.class);
    private GWC gwc;

    public CachingWebMapService(GWC gwc) {
        this.gwc = gwc;
    }

    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        ConveyorTile cachedTile;
        if (!this.gwc.isWMSIntegrationEnabled()) {
            return (WebMap)invocation.proceed();
        }
        Method method = invocation.getMethod();
        Assert.isTrue((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Assert.isTrue((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Assert.isTrue((arguments.length == 1 ? 1 : 0) != 0);
        Assert.isInstanceOf(GetMapRequest.class, (Object)arguments[0]);
        GetMapRequest request = (GetMapRequest)arguments[0];
        boolean tiled = request.isTiled();
        if (tiled && (cachedTile = this.gwc.dispatch(request)) != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("GetMap request intercepted, serving cached content: " + request);
            }
            String ifNoneMatch = request.getHttpRequestHeader("If-None-Match");
            String hexTag = Long.toHexString(cachedTile.getTSCreated());
            if (hexTag.equals(ifNoneMatch)) {
                LOGGER.finer("ETag matches, returning 304");
                throw new HttpErrorCodeException(304);
            }
            LOGGER.finer("No matching ETag, returning cached tile");
            byte[] mapContents = cachedTile.getContent();
            String mimeType = cachedTile.getMimeType().getMimeType();
            RawMap map = new RawMap(null, mapContents, mimeType);
            map.setResponseHeader("Cache-Control", "no-cache");
            map.setResponseHeader("ETag", Long.toHexString(cachedTile.getTSCreated()));
            return map;
        }
        return (WebMap)invocation.proceed();
    }
}

