/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionPlugin;
import org.geoserver.wfs.WFSException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCTransactionListener
implements TransactionPlugin {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc.GWCTransactionListener");
    private final Catalog catalog;
    private final GWC gwc;
    private final Map<EObject, ReferencedEnvelope> affectedBounds;
    private final Map<EObject, Set<String>> affectedLayers;

    public GWCTransactionListener(Catalog cat, GWC gwc) {
        this.catalog = cat;
        this.gwc = gwc;
        this.affectedBounds = new ConcurrentHashMap<EObject, ReferencedEnvelope>();
        this.affectedLayers = new ConcurrentHashMap<EObject, Set<String>>();
    }

    public TransactionType beforeTransaction(TransactionType request) throws WFSException {
        return request;
    }

    public void beforeCommit(TransactionType request) throws WFSException {
    }

    public void afterTransaction(TransactionType request, boolean committed) {
        try {
            this.afterTransactionInternal(request, committed);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error trying to truncate the transaction affected area", e);
        }
    }

    private void afterTransactionInternal(TransactionType request, boolean committed) {
        List<EObject> transactionElements = this.getTransactionElements(request);
        for (EObject transactionElement : transactionElements) {
            ReferencedEnvelope affectedBounds = this.affectedBounds.remove(transactionElement);
            Set<String> affectedLayers = this.affectedLayers.remove(transactionElement);
            if (!committed || affectedBounds == null) continue;
            Assert.notNull(affectedLayers);
            if (affectedBounds.isEmpty()) continue;
            for (String layerName : affectedLayers) {
                try {
                    this.gwc.truncate(layerName, affectedBounds);
                }
                catch (GeoWebCacheException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<EObject> getTransactionElements(TransactionType request) {
        EList insert = request.getInsert();
        EList update = request.getUpdate();
        EList delete = request.getDelete();
        ArrayList<EObject> allTransactionElements = new ArrayList<EObject>();
        allTransactionElements.addAll((Collection<EObject>)insert);
        allTransactionElements.addAll((Collection<EObject>)update);
        allTransactionElements.addAll((Collection<EObject>)delete);
        return allTransactionElements;
    }

    public int getPriority() {
        return 0;
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        try {
            this.dataStoreChangeInternal(event);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error pre computing the transaction's affected area", e);
        }
    }

    private void dataStoreChangeInternal(TransactionEvent event) {
        Object source = event.getSource();
        Assert.isTrue((source instanceof InsertElementType || source instanceof UpdateElementType || source instanceof DeleteElementType ? 1 : 0) != 0);
        EObject originatingTransactionRequest = (EObject)source;
        Assert.notNull((Object)originatingTransactionRequest);
        TransactionEventType type = event.getType();
        SimpleFeatureCollection affectedFeatures = event.getAffectedFeatures();
        if (this.isIgnorablePostEvent(originatingTransactionRequest, type)) {
            return;
        }
        Set<String> affectedLayers = this.findAffectedCachedLayers(event);
        if (affectedLayers.isEmpty()) {
            return;
        }
        if (TransactionEventType.PRE_INSERT == type || TransactionEventType.PRE_UPDATE == type || TransactionEventType.PRE_DELETE == type) {
            ReferencedEnvelope preBounds = affectedFeatures.getBounds();
            this.affectedLayers.put(originatingTransactionRequest, affectedLayers);
            this.affectedBounds.put(originatingTransactionRequest, preBounds);
        } else if (TransactionEventType.POST_UPDATE == type && affectedFeatures != null) {
            ReferencedEnvelope bounds = this.affectedBounds.get(originatingTransactionRequest);
            ReferencedEnvelope postBounds = affectedFeatures.getBounds();
            Assert.isTrue((boolean)bounds.getCoordinateReferenceSystem().equals(postBounds.getCoordinateReferenceSystem()));
            bounds.expandToInclude((Envelope)postBounds);
        } else {
            throw new IllegalArgumentException("Unrecognized transaction event type: " + type);
        }
    }

    private boolean isIgnorablePostEvent(Object originatingTransactionRequest, TransactionEventType type) {
        return TransactionEventType.POST_UPDATE == type && !this.affectedBounds.containsKey(originatingTransactionRequest);
    }

    private Set<String> findAffectedCachedLayers(TransactionEvent event) {
        String layerName = this.getQualifiedLayerName(event);
        Set<String> affectedLayers = this.findLayerGroupsOf(layerName);
        affectedLayers.add(layerName);
        return affectedLayers;
    }

    private Set<String> findLayerGroupsOf(String layerName) {
        HashSet<String> affectedLayerGroups = new HashSet<String>();
        block0: for (LayerGroupInfo lgi : this.catalog.getLayerGroups()) {
            for (LayerInfo li : lgi.getLayers()) {
                if (!li.getResource().getPrefixedName().equals(layerName)) continue;
                affectedLayerGroups.add(lgi.getName());
                continue block0;
            }
        }
        return affectedLayerGroups;
    }

    private String getQualifiedLayerName(TransactionEvent event) {
        String layerName;
        QName name = event.getLayerName();
        String namespaceURI = name.getNamespaceURI();
        String localName = name.getLocalPart();
        if (!"".equals(namespaceURI)) {
            NamespaceInfo namespaceInfo = this.catalog.getNamespaceByURI(namespaceURI);
            if (namespaceInfo == null) {
                log.info("Can't find namespace info for layer " + name + ". Cache not truncated");
                throw new NoSuchElementException("Layer not found: " + name);
            }
            String prefix = namespaceInfo.getPrefix();
            layerName = String.valueOf(prefix) + ":" + localName;
        } else {
            LayerInfo layerInfo = this.catalog.getLayerByName(localName);
            if (layerInfo == null) {
                log.info("Can't find layer " + localName + ". Cache not truncated");
                throw new NoSuchElementException("Layer not found: " + localName);
            }
            ResourceInfo resource = layerInfo.getResource();
            layerName = resource.getPrefixedName();
        }
        return layerName;
    }
}

