/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.OneTimeSetupTest;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class CachingExtendedCapabilitiesProviderTest
extends GeoServerTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new CachingExtendedCapabilitiesProviderTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setProxyBaseUrl("../wms/src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    public void testCapabilitiesContributedInternalDTD() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        DocumentType doctype = dom.getDoctype();
        CachingExtendedCapabilitiesProviderTest.assertNotNull((Object)doctype);
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"WMT_MS_Capabilities", (String)doctype.getName());
        String systemId = doctype.getSystemId();
        CachingExtendedCapabilitiesProviderTest.assertEquals((String)"../wms/src/test/resources/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd", (String)systemId);
        String internalSubset = doctype.getInternalSubset();
        CachingExtendedCapabilitiesProviderTest.assertNotNull((Object)internalSubset);
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.trim().startsWith("<!ELEMENT VendorSpecificCapabilities"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("(TileSet*)"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT TileSet (SRS,BoundingBox?,Resolutions,Width,Height,Format,Layers*,Styles*)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Resolutions (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Width (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Height (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Layers (#PCDATA)>"));
        CachingExtendedCapabilitiesProviderTest.assertTrue((String)internalSubset, (boolean)internalSubset.contains("<!ELEMENT Styles (#PCDATA)>"));
        System.out.println("so?");
    }

    public void testTileSets() throws Exception {
        int numLayers = this.getCatalog().getLayers().size();
        int numCRSs = 2;
        int numFormats = 5;
        int numTileSets = numLayers * 2 * 5;
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.1.1&tiled=true"), false);
        String tileSetPath = "/WMT_MS_Capabilities/Capability/VendorSpecificCapabilities/TileSet";
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(numTileSets), (String)("count(" + tileSetPath + ")"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/SRS"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/BoundingBox"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Resolutions"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Width"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Height"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Format"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Layers"), (Document)dom);
        XMLAssert.assertXpathExists((String)(String.valueOf(tileSetPath) + "[1]/Styles"), (Document)dom);
    }
}

