/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3287178222706781438L;
    private boolean directWMSIntegrationEnabled;
    private boolean WMSCEnabled;
    private boolean WMTSEnabled;
    private boolean TMSEnabled;
    private boolean cacheLayersByDefault = true;
    private transient boolean cacheDeclaredCRS;
    private boolean cacheNonDefaultStyles;
    private int metaTilingX;
    private int metaTilingY;
    private int gutter;
    private HashSet<String> defaultCachingGridSetIds;
    private HashSet<String> defaultCoverageCacheFormats;
    private HashSet<String> defaultVectorCacheFormats;
    private HashSet<String> defaultOtherCacheFormats;

    public GWCConfig() {
        this.setOldDefaults();
        String png = "image/png";
        String jpeg = "image/jpeg";
        this.setDefaultCoverageCacheFormats(Collections.singleton(jpeg));
        this.setDefaultOtherCacheFormats(new HashSet<String>(Arrays.asList(png, jpeg)));
        this.setDefaultVectorCacheFormats(Collections.singleton(png));
    }

    public boolean isCacheLayersByDefault() {
        return this.cacheLayersByDefault;
    }

    public void setCacheLayersByDefault(boolean cacheLayersByDefault) {
        this.cacheLayersByDefault = cacheLayersByDefault;
    }

    public boolean isDirectWMSIntegrationEnabled() {
        return this.directWMSIntegrationEnabled;
    }

    public void setDirectWMSIntegrationEnabled(boolean directWMSIntegrationEnabled) {
        this.directWMSIntegrationEnabled = directWMSIntegrationEnabled;
    }

    public boolean isWMSCEnabled() {
        return this.WMSCEnabled;
    }

    public void setWMSCEnabled(boolean wMSCEnabled) {
        this.WMSCEnabled = wMSCEnabled;
    }

    public boolean isWMTSEnabled() {
        return this.WMTSEnabled;
    }

    public void setWMTSEnabled(boolean wMTSEnabled) {
        this.WMTSEnabled = wMTSEnabled;
    }

    public boolean isTMSEnabled() {
        return this.TMSEnabled;
    }

    public void setTMSEnabled(boolean tMSEnabled) {
        this.TMSEnabled = tMSEnabled;
    }

    private boolean isCacheDeclaredCRS() {
        return this.cacheDeclaredCRS;
    }

    private void setCacheDeclaredCRS(boolean cacheDeclaredCRS) {
        this.cacheDeclaredCRS = cacheDeclaredCRS;
    }

    public boolean isCacheNonDefaultStyles() {
        return this.cacheNonDefaultStyles;
    }

    public void setCacheNonDefaultStyles(boolean cacheNonDefaultStyles) {
        this.cacheNonDefaultStyles = cacheNonDefaultStyles;
    }

    public Set<String> getDefaultCachingGridSetIds() {
        return this.defaultCachingGridSetIds;
    }

    public void setDefaultCachingGridSetIds(Set<String> defaultCachingGridSetIds) {
        this.defaultCachingGridSetIds = new HashSet<String>(defaultCachingGridSetIds);
    }

    public Set<String> getDefaultCoverageCacheFormats() {
        return this.defaultCoverageCacheFormats;
    }

    public void setDefaultCoverageCacheFormats(Set<String> defaultCoverageCacheFormats) {
        this.defaultCoverageCacheFormats = new HashSet<String>(defaultCoverageCacheFormats);
    }

    public Set<String> getDefaultVectorCacheFormats() {
        return this.defaultVectorCacheFormats;
    }

    public void setDefaultVectorCacheFormats(Set<String> defaultVectorCacheFormats) {
        this.defaultVectorCacheFormats = new HashSet<String>(defaultVectorCacheFormats);
    }

    public Set<String> getDefaultOtherCacheFormats() {
        return this.defaultOtherCacheFormats;
    }

    public void setDefaultOtherCacheFormats(Set<String> defaultOtherCacheFormats) {
        this.defaultOtherCacheFormats = new HashSet<String>(defaultOtherCacheFormats);
    }

    public static GWCConfig getOldDefaults() {
        GWCConfig config = new GWCConfig();
        config.setOldDefaults();
        return config;
    }

    private void setOldDefaults() {
        this.setCacheDeclaredCRS(false);
        this.setCacheLayersByDefault(true);
        this.setMetaTilingX(4);
        this.setMetaTilingY(4);
        this.setGutter(0);
        this.setCacheNonDefaultStyles(true);
        this.setDefaultCachingGridSetIds(new HashSet<String>(Arrays.asList("EPSG:4326", "EPSG:900913")));
        HashSet<String> oldDefaultFormats = new HashSet<String>(Arrays.asList("image/png", "image/jpeg"));
        this.setDefaultCoverageCacheFormats(oldDefaultFormats);
        this.setDefaultOtherCacheFormats(oldDefaultFormats);
        this.setDefaultVectorCacheFormats(oldDefaultFormats);
        this.setDirectWMSIntegrationEnabled(false);
        this.setWMSCEnabled(true);
        this.setWMTSEnabled(true);
        this.setTMSEnabled(true);
    }

    public int getMetaTilingX() {
        return this.metaTilingX;
    }

    public void setMetaTilingX(int metaFactorX) {
        this.metaTilingX = metaFactorX;
    }

    public int getMetaTilingY() {
        return this.metaTilingY;
    }

    public void setMetaTilingY(int metaFactorY) {
        this.metaTilingY = metaFactorY;
    }

    public int getGutter() {
        return this.gutter;
    }

    public void setGutter(int gutter) {
        this.gutter = gutter;
    }

    public GWCConfig clone() {
        GWCConfig clone;
        try {
            clone = (GWCConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.setDefaultCachingGridSetIds(this.getDefaultCachingGridSetIds());
        clone.setDefaultCoverageCacheFormats(this.getDefaultCoverageCacheFormats());
        clone.setDefaultVectorCacheFormats(this.getDefaultVectorCacheFormats());
        clone.setDefaultOtherCacheFormats(this.getDefaultOtherCacheFormats());
        return clone;
    }

    public boolean isEnabled(String serviceId) {
        Assert.notNull((Object)serviceId);
        if ("wms".equals(serviceId)) {
            return this.isWMSCEnabled();
        }
        if ("wmts".equals(serviceId)) {
            return this.isWMTSEnabled();
        }
        if ("tms".equals(serviceId)) {
            return this.isTMSEnabled();
        }
        return true;
    }
}

