/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogPostModifyEventImpl;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CatalogStyleChangeListenerTest
extends TestCase {
    private final String STYLE_NAME = "highways";
    private String STYLE_NAME_MODIFIED = "highways_modified";
    private final String PREFIXED_RESOURCE_NAME = "mock:Layer";
    private CatalogConfiguration mockConfiguration;
    private ResourceInfo mockResourceInfo;
    private LayerInfo mockLayerInfo;
    private StyleInfo mockStyle;
    private GeoServerTileLayer mockTileLayer;
    private GeoServerTileLayerInfo mockTileLayerInfo;
    private CatalogModifyEventImpl styleNameModifyEvent;
    private CatalogStyleChangeListener listener;

    protected void setUp() throws Exception {
        this.mockConfiguration = (CatalogConfiguration)Mockito.mock(CatalogConfiguration.class);
        this.mockStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)this.mockStyle.getName()).thenReturn((Object)"highways");
        this.mockResourceInfo = (ResourceInfo)Mockito.mock(FeatureTypeInfo.class);
        Mockito.when((Object)this.mockResourceInfo.getPrefixedName()).thenReturn((Object)"mock:Layer");
        this.mockLayerInfo = (LayerInfo)Mockito.mock(LayerInfo.class);
        Mockito.when((Object)this.mockLayerInfo.getResource()).thenReturn((Object)this.mockResourceInfo);
        this.mockTileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        this.mockTileLayerInfo = (GeoServerTileLayerInfo)Mockito.mock(GeoServerTileLayerInfo.class);
        Mockito.when((Object)this.mockTileLayer.getInfo()).thenReturn((Object)this.mockTileLayerInfo);
        Mockito.when((Object)this.mockTileLayer.getName()).thenReturn((Object)"mock:Layer");
        Mockito.when((Object)this.mockConfiguration.getTileLayersForStyle((String)Matchers.eq((Object)"highways"))).thenReturn(Collections.singletonList(this.mockTileLayer));
        this.listener = new CatalogStyleChangeListener(this.mockConfiguration);
        this.styleNameModifyEvent = new CatalogModifyEventImpl();
        this.styleNameModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList(this.STYLE_NAME_MODIFIED));
    }

    public void testIgnorableChange() throws Exception {
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("fileName"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setPropertyNames(Arrays.asList("name"));
        this.styleNameModifyEvent.setOldValues(Arrays.asList("highways"));
        this.styleNameModifyEvent.setNewValues(Arrays.asList("highways"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        this.styleNameModifyEvent.setSource((CatalogInfo)Mockito.mock(LayerInfo.class));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.never())).truncate(Matchers.anyString(), Matchers.anyString());
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.never())).save((GeoServerTileLayer)Matchers.anyObject());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.never())).getInfo();
        ((GeoServerTileLayerInfo)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.never())).getCachedStyles();
    }

    public void testRenameDefaultStyle() throws Exception {
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.never())).truncate(Matchers.anyString(), Matchers.anyString());
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.never())).save((GeoServerTileLayer)Matchers.anyObject());
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.atLeastOnce())).getInfo();
        ((GeoServerTileLayerInfo)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.atLeastOnce())).getCachedStyles();
    }

    public void testRenameAlternateStyle() throws Exception {
        Mockito.when((Object)this.mockTileLayerInfo.getCachedStyles()).thenReturn(Collections.singleton("highways"));
        this.listener.handleModifyEvent((CatalogModifyEvent)this.styleNameModifyEvent);
        ((GeoServerTileLayerInfo)Mockito.verify((Object)this.mockTileLayerInfo, (VerificationMode)Mockito.times((int)1))).setCachedStyles((Set)Matchers.eq(Collections.singleton(this.STYLE_NAME_MODIFIED)));
        ((GeoServerTileLayer)Mockito.verify((Object)this.mockTileLayer, (VerificationMode)Mockito.times((int)1))).resetParameterFilters();
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"mock:Layer"), (String)Matchers.eq((Object)"highways"));
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.times((int)1))).save((GeoServerTileLayer)Matchers.same((Object)this.mockTileLayer));
    }

    public void testLayerInfoDefaultOrAlternateStyleChanged() throws Exception {
        Mockito.when((Object)this.mockConfiguration.getLayerInfosFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(this.mockLayerInfo));
        Mockito.when((Object)this.mockConfiguration.getLayerGroupsFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn((Object)Collections.EMPTY_LIST);
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"mock:Layer"), (String)Matchers.eq((Object)"highways"));
    }

    public void testLayerGroupInfoImplicitOrExplicitStyleChanged() throws Exception {
        LayerGroupInfo mockGroup = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        Mockito.when((Object)mockGroup.getName()).thenReturn((Object)"mockGroup");
        Mockito.when((Object)this.mockConfiguration.getLayerInfosFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn((Object)Collections.EMPTY_LIST);
        Mockito.when((Object)this.mockConfiguration.getLayerGroupsFor((StyleInfo)Matchers.same((Object)this.mockStyle))).thenReturn(Collections.singleton(mockGroup));
        CatalogPostModifyEventImpl postModifyEvent = new CatalogPostModifyEventImpl();
        postModifyEvent.setSource((CatalogInfo)this.mockStyle);
        this.listener.handlePostModifyEvent((CatalogPostModifyEvent)postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration, (VerificationMode)Mockito.times((int)1))).truncate((String)Matchers.eq((Object)"mockGroup"));
    }
}

