/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.gwc.FakeHttpServletRequest;
import org.geoserver.gwc.FakeHttpServletResponse;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.storage.BDBQuotaStore;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.service.Service;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWC
implements DisposableBean,
InitializingBean {
    private static GWC INSTANCE;
    private static Logger log;
    private final TileLayerDispatcher tld;
    private final StorageBroker storageBroker;
    private final TileBreeder tileBreeder;
    private final BDBQuotaStore quotaStore;
    private final GWCConfigPersister gwcConfigPersister;
    private final Dispatcher owsDispatcher;
    private final GridSetBroker gridSetBroker;
    private DiskQuotaMonitor monitor;
    private CatalogLayerEventListener catalogLayerEventListener;
    private CatalogStyleChangeListener catalogStyleChangeListener;
    private final Catalog rawCatalog;

    static {
        log = Logging.getLogger(GWC.class);
    }

    public GWC(GWCConfigPersister gwcConfigPersister, StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gridSetBroker, TileBreeder tileBreeder, BDBQuotaStore quotaStore, DiskQuotaMonitor monitor, Dispatcher owsDispatcher, Catalog rawCatalog) {
        this.gwcConfigPersister = gwcConfigPersister;
        this.tld = tld;
        this.storageBroker = sb;
        this.gridSetBroker = gridSetBroker;
        this.tileBreeder = tileBreeder;
        this.monitor = monitor;
        this.owsDispatcher = owsDispatcher;
        this.quotaStore = quotaStore;
        this.rawCatalog = rawCatalog;
    }

    public static synchronized GWC get() {
        if (INSTANCE == null && (INSTANCE = (GWC)GeoServerExtensions.bean(GWC.class)) == null) {
            throw new IllegalStateException("No bean of type " + GWC.class.getName() + " found by GeoServerExtensions");
        }
        return INSTANCE;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public void initialize() {
    }

    public void destroy() throws Exception {
        Catalog catalog = this.getCatalog();
        if (this.catalogLayerEventListener != null) {
            catalog.removeListener((CatalogListener)this.catalogLayerEventListener);
        }
        if (this.catalogStyleChangeListener != null) {
            catalog.removeListener((CatalogListener)this.catalogStyleChangeListener);
        }
    }

    private Catalog getCatalog() {
        return this.rawCatalog;
    }

    public GWCConfig getConfig() {
        return this.gwcConfigPersister.getConfig();
    }

    public void truncate(String layerName) {
        String styleName = null;
        String gridSetId = null;
        BoundingBox bounds = null;
        String format = null;
        this.truncate(layerName, styleName, gridSetId, bounds, format);
    }

    public void truncate(String layerName, String styleName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Truncate for layer/style called. Checking if style '" + styleName + "' is cached for layer '" + layerName + "'");
        }
        if (!this.isStyleCached(layerName, styleName)) {
            log.fine("Style '" + styleName + "' is not cached for layer " + layerName + "'. No need to truncate.");
            return;
        }
        log.fine("truncating '" + layerName + "' for style '" + styleName + "'");
        String gridSetId = null;
        BoundingBox bounds = null;
        String format = null;
        this.truncate(layerName, styleName, gridSetId, bounds, format);
    }

    public void truncate(String layerName, ReferencedEnvelope bounds) throws GeoWebCacheException {
        TileLayer tileLayer = this.tld.getTileLayer(layerName);
        Set gridSubSets = tileLayer.getGridSubsets();
        for (String layerGridId : gridSubSets) {
            GridSubset layerGrid = tileLayer.getGridSubset(layerGridId);
            BoundingBox intersectingBounds = this.getIntersectingBounds(layerName, layerGrid, bounds);
            if (intersectingBounds == null) continue;
            String gridSetId = layerGrid.getName();
            String styleName = null;
            String format = null;
            this.truncate(layerName, styleName, gridSetId, intersectingBounds, format);
        }
    }

    private BoundingBox getIntersectingBounds(String layerName, GridSubset layerGrid, ReferencedEnvelope bounds) {
        ReferencedEnvelope truncateBoundsInGridsetCrs;
        CoordinateReferenceSystem gridSetCrs;
        GridSet gridSet = layerGrid.getGridSet();
        String gridSetId = gridSet.getName();
        SRS srs = gridSet.getSrs();
        try {
            gridSetCrs = CRS.decode((String)("EPSG:" + srs.getNumber()), (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't decode SRS for layer '" + layerName + "': ESPG:" + srs.getNumber());
        }
        try {
            truncateBoundsInGridsetCrs = bounds.transform(gridSetCrs, true);
        }
        catch (Exception e) {
            log.warning("Can't truncate layer " + layerName + ": error transforming requested bounds to layer gridset " + gridSetId + ": " + e.getMessage());
            return null;
        }
        double minx = truncateBoundsInGridsetCrs.getMinX();
        double miny = truncateBoundsInGridsetCrs.getMinY();
        double maxx = truncateBoundsInGridsetCrs.getMaxX();
        double maxy = truncateBoundsInGridsetCrs.getMaxY();
        BoundingBox reqBounds = new BoundingBox(minx, miny, maxx, maxy);
        BoundingBox layerBounds = layerGrid.getCoverageBestFitBounds();
        if (!layerBounds.intersects(reqBounds)) {
            log.fine("Requested truncation bounds do not intersect cached layer bounds, ignoring truncate request");
            return null;
        }
        BoundingBox intersectingBounds = BoundingBox.intersection((BoundingBox)layerBounds, (BoundingBox)reqBounds);
        return intersectingBounds;
    }

    private void truncate(String layerName, String styleName, String gridSetName, BoundingBox bounds, String format) {
        List<MimeType> mimeTypes;
        Set<String> styleNames;
        TileLayer layer = this.getTileLayerByName(layerName);
        if (styleName == null) {
            styleNames = this.getCachedStyles(layerName);
            if (styleNames.size() == 0) {
                styleNames.add("");
            }
        } else {
            styleNames = Collections.singleton(styleName);
        }
        Set<String> gridSetIds = gridSetName == null ? layer.getGridSubsets() : Collections.singleton(gridSetName);
        if (format == null) {
            mimeTypes = layer.getMimeTypes();
        } else {
            try {
                mimeTypes = Collections.singletonList(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                throw new RuntimeException();
            }
        }
        String defaultStyle = layer.getStyles();
        for (String gridSetId : gridSetIds) {
            GridSubset gridSubset = layer.getGridSubset(gridSetId);
            for (String style : styleNames) {
                Map<String, String> parameters;
                if (style.length() == 0 || style.equals(defaultStyle)) {
                    log.finer("'" + style + "' is the layer's default style, " + "not adding a parameter filter");
                    parameters = null;
                } else {
                    parameters = Collections.singletonMap("STYLES", style);
                }
                for (MimeType mime : mimeTypes) {
                    String formatName = mime.getFormat();
                    this.truncate(layer, bounds, gridSubset, formatName, parameters);
                }
            }
        }
    }

    private void truncate(TileLayer layer, BoundingBox bounds, GridSubset gridSubset, String formatName, Map<String, String> parameters) {
        boolean threadCount = true;
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        GWCTask.TYPE taskType = GWCTask.TYPE.TRUNCATE;
        SeedRequest req = new SeedRequest(layer.getName(), bounds, gridSubset.getName(), 1, zoomStart, zoomStop, formatName, taskType, parameters);
        try {
            TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)layer);
            boolean filterUpdate = false;
            GWCTask[] tasks = this.tileBreeder.createTasks(tr, taskType, 1, filterUpdate);
            this.tileBreeder.dispatchTasks(tasks);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isStyleCached(String layerName, String styleName) {
        Set<String> cachedStyles = this.getCachedStyles(layerName);
        boolean styleIsCached = cachedStyles.contains(styleName);
        return styleIsCached;
    }

    private Set<String> getCachedStyles(String layerName) {
        List parameterFilters;
        TileLayer l = this.getTileLayerByName(layerName);
        HashSet<String> cachedStyles = new HashSet<String>();
        String defaultStyle = l.getStyles();
        if (defaultStyle != null) {
            cachedStyles.add(defaultStyle);
        }
        if ((parameterFilters = l.getParameterFilters()) != null) {
            for (ParameterFilter pf : parameterFilters) {
                if (!"STYLES".equalsIgnoreCase(pf.getKey())) continue;
                cachedStyles.add(pf.getDefaultValue());
                cachedStyles.addAll(pf.getLegalValues());
                break;
            }
        }
        return cachedStyles;
    }

    public synchronized void layerRemoved(String prefixedName) {
        try {
            this.storageBroker.delete(prefixedName);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        try {
            this.tld.reInit();
        }
        catch (Exception gwce) {
            log.log(Level.WARNING, "Unable to reinit TileLayerDispatcher", gwce);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ConveyorTile dispatch(GetMapRequest request) {
        MimeType mimeType;
        GridSubset gridSubset;
        TileLayer tileLayer;
        String layerName = (String)request.getRawKvp().get("LAYERS");
        if (layerName.indexOf(44) != -1) {
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            return null;
        }
        if (!tileLayer.isEnabled()) {
            return null;
        }
        if (!this.isCachingPossible(tileLayer, request)) {
            return null;
        }
        try {
            String srs = request.getSRS();
            int epsgId = Integer.parseInt(srs.substring(srs.indexOf(58) + 1));
            SRS srs2 = SRS.getSRS((int)epsgId);
            gridSubset = tileLayer.getGridSubsetForSRS(srs2);
            if (gridSubset == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (request.getWidth() != gridSubset.getTileWidth()) return null;
        if (request.getHeight() != gridSubset.getTileHeight()) {
            return null;
        }
        try {
            mimeType = MimeType.createFromFormat((String)request.getFormat());
            List tileLayerFormats = tileLayer.getMimeTypes();
            if (!tileLayerFormats.contains(mimeType)) {
                return null;
            }
        }
        catch (MimeException me) {
            return null;
        }
        ConveyorTile tileResp = null;
        try {
            long[] tileIndex;
            HttpServletRequest servletReq = null;
            HttpServletResponse servletResp = null;
            String gridSetId = gridSubset.getName();
            Envelope bbox = request.getBbox();
            BoundingBox tileBounds = new BoundingBox(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            try {
                tileIndex = gridSubset.closestIndex(tileBounds);
                if (!gridSubset.covers(tileIndex)) {
                    return null;
                }
            }
            catch (GridMismatchException e) {
                return null;
            }
            Map requestParameterMap = request.getRawKvp();
            Map fullParameters = tileLayer.getModifiableParameters(requestParameterMap, "UTF-8");
            ConveyorTile tileReq = new ConveyorTile(this.storageBroker, layerName, gridSetId, tileIndex, mimeType, fullParameters, servletReq, servletResp);
            return tileLayer.getTile(tileReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tileResp;
    }

    private boolean isCachingPossible(TileLayer layer, GetMapRequest request) {
        Map<String, ParameterFilter> filters;
        if (request.getRemoteOwsType() != null || request.getRemoteOwsURL() != null) {
            return false;
        }
        if (request.getEnv() != null && !request.getEnv().isEmpty()) {
            return false;
        }
        List parameterFilters = layer.getParameterFilters();
        if (parameterFilters != null && parameterFilters.size() > 0) {
            filters = new HashMap();
            for (ParameterFilter pf : parameterFilters) {
                filters.put(pf.getKey().toUpperCase(), pf);
            }
        } else {
            filters = Collections.emptyMap();
        }
        if (request.getFormatOptions() != null && !request.getFormatOptions().isEmpty() && !this.filterApplies(filters, request, "FORMAT_OPTIONS")) {
            return false;
        }
        if (0.0 != request.getAngle() && !this.filterApplies(filters, request, "ANGLE")) {
            return false;
        }
        if (request.getRawKvp().get("BGCOLOR") != null && !this.filterApplies(filters, request, "BGCOLOR")) {
            return false;
        }
        if (request.getBuffer() != 0 && !this.filterApplies(filters, request, "BUFFER")) {
            return false;
        }
        if (request.getCQLFilter() != null && !request.getCQLFilter().isEmpty() && !this.filterApplies(filters, request, "CQL_FILTER")) {
            return false;
        }
        if (!Double.isNaN(request.getElevation()) && !this.filterApplies(filters, request, "ELEVATION")) {
            return false;
        }
        if (request.getFeatureId() != null && !request.getFeatureId().isEmpty() && !this.filterApplies(filters, request, "FEATUREID")) {
            return false;
        }
        if (request.getFilter() != null && !request.getFilter().isEmpty() && !this.filterApplies(filters, request, "FILTER")) {
            return false;
        }
        if (request.getPalette() != null && !this.filterApplies(filters, request, "PALETTE")) {
            return false;
        }
        if (request.getSld() != null && !this.filterApplies(filters, request, "SLD")) {
            return false;
        }
        if (request.getSldBody() != null && !this.filterApplies(filters, request, "SLD_BODY")) {
            return false;
        }
        if (request.getStartIndex() != null && !this.filterApplies(filters, request, "STARTINDEX")) {
            return false;
        }
        if (request.getMaxFeatures() != null && !this.filterApplies(filters, request, "MAXFEATURES")) {
            return false;
        }
        if (request.getTime() != null && !request.getTime().isEmpty() && !this.filterApplies(filters, request, "TIME")) {
            return false;
        }
        if (request.getViewParams() != null && !request.getViewParams().isEmpty() && !this.filterApplies(filters, request, "VIEWPARAMS")) {
            return false;
        }
        return request.getFeatureVersion() == null || this.filterApplies(filters, request, "FEATUREVERSION");
    }

    private boolean filterApplies(Map<String, ParameterFilter> filters, GetMapRequest request, String key) {
        ParameterFilter parameterFilter = filters.get(key);
        if (parameterFilter == null) {
            return false;
        }
        String parameter = (String)request.getRawKvp().get(key);
        boolean applies = parameterFilter.applies(parameter);
        return applies;
    }

    public TileLayer getTileLayerByName(String layerName) throws IllegalArgumentException {
        TileLayer tileLayer;
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return tileLayer;
    }

    public Set<String> getTileLayerNames() {
        return this.tld.getLayerNames();
    }

    public Iterable<TileLayer> getTileLayers() {
        return this.tld.getLayerList();
    }

    public Iterable<TileLayer> getTileLayersByNamespacePrefix(String nsPrefix) {
        if (nsPrefix == null) {
            return this.getTileLayers();
        }
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceFilter = catalog.getNamespaceByPrefix(nsPrefix);
        if (namespaceFilter == null) {
            return this.getTileLayers();
        }
        ArrayList<TileLayer> filteredLayers = new ArrayList<TileLayer>();
        for (TileLayer tileLayer : this.getTileLayers()) {
            NamespaceInfo layerNamespace;
            String layerName = tileLayer.getName();
            LayerInfo layerInfo = catalog.getLayerByName(layerName);
            if (layerInfo == null || !namespaceFilter.equals((Object)(layerNamespace = layerInfo.getResource().getNamespace()))) continue;
            filteredLayers.add(tileLayer);
        }
        return filteredLayers;
    }

    public boolean isDiskQuotaAvailable() {
        DiskQuotaMonitor diskQuotaMonitor = this.getDiskQuotaMonitor();
        return diskQuotaMonitor.isEnabled();
    }

    public DiskQuotaConfig getDiskQuotaConfig() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        return monitor.getConfig();
    }

    private DiskQuotaMonitor getDiskQuotaMonitor() {
        return this.monitor;
    }

    public void saveConfig(GWCConfig gwcConfig) throws IOException {
        this.gwcConfigPersister.save(gwcConfig);
    }

    public void saveDiskQuotaConfig(DiskQuotaConfig config) {
        Assert.isTrue((boolean)this.isDiskQuotaAvailable());
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        monitor.saveConfig(config);
    }

    public Quota getGlobalQuota() {
        Assert.isTrue((boolean)this.isDiskQuotaAvailable());
        return this.getDiskQuotaConfig().getGlobalQuota();
    }

    public Quota getGlobalUsedQuota() {
        Assert.isTrue((boolean)this.isDiskQuotaAvailable());
        try {
            return this.quotaStore.getGloballyUsedQuota();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Quota getQuotaLimit(String layerName) {
        Assert.isTrue((boolean)this.isDiskQuotaAvailable());
        DiskQuotaConfig disQuotaConfig = this.getDiskQuotaConfig();
        List layerQuotas = disQuotaConfig.getLayerQuotas();
        if (layerQuotas == null) {
            return null;
        }
        for (LayerQuota lq : layerQuotas) {
            if (!layerName.equals(lq.getLayer())) continue;
            return new Quota(lq.getQuota());
        }
        return null;
    }

    public Quota getUsedQuota(String layerName) {
        Assert.isTrue((boolean)this.isDiskQuotaAvailable());
        try {
            Quota usedQuotaByLayerName = this.quotaStore.getUsedQuotaByLayerName(layerName);
            return usedQuotaByLayerName;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Resource dispatchOwsRequest(Map<String, String> params, Cookie[] cookies) throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest(params, cookies);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        this.owsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        return new ByteArrayResource(resp.getBytes());
    }

    public GridSetBroker getGridSetBroker() {
        return this.gridSetBroker;
    }

    public List<LayerInfo> getLayerInfos() {
        return this.getCatalog().getLayers();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        return this.getCatalog().getLayerGroups();
    }

    public LayerInfo getLayerInfoByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerName) {
        return this.getCatalog().getLayerGroupByName(layerName);
    }

    public void layerAdded(GeoServerTileLayer layer) {
        String layerName = layer.getName();
        if (this.isDiskQuotaAvailable()) {
            try {
                this.quotaStore.createLayer(layerName);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void layerRenamed(String oldLayerName, String newLayerName) {
        try {
            log.info("Renaming GWC TileLayer '" + oldLayerName + "' as '" + newLayerName + "'");
            this.storageBroker.rename(oldLayerName, newLayerName);
        }
        catch (StorageException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public boolean isServiceEnabled(Service service) {
        return this.getConfig().isEnabled(service.getPathName());
    }

    public boolean tileLayerExists(String layerName) {
        return this.tld.layerExists(layerName);
    }

    public Set<String> getTileLayersByFeatureType(String namespaceURI, String typeName) {
        NamespaceInfo namespace = namespaceURI == null || "".equals(namespaceURI) ? this.getCatalog().getDefaultNamespace() : this.getCatalog().getNamespaceByURI(namespaceURI);
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName(namespace, typeName);
        List layers = this.getCatalog().getLayers((ResourceInfo)typeInfo);
        HashSet<String> affectedLayers = new HashSet<String>();
        for (LayerInfo layer : layers) {
            if (!this.tileLayerExists(layer.getResource().getPrefixedName())) continue;
            affectedLayers.add(layer.getResource().getPrefixedName());
        }
        for (LayerGroupInfo lgi : this.getLayerGroups()) {
            if (!this.tileLayerExists(lgi.getName())) continue;
            for (LayerInfo li : lgi.getLayers()) {
                ResourceInfo resource = li.getResource();
                if (!typeInfo.equals(resource)) continue;
                affectedLayers.add(lgi.getName());
            }
        }
        return affectedLayers;
    }
}

