/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.config.GWCConfig;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoServerTileLayerInfo {
    private static final String CONFIG_KEY_ENABLED = "GWC.enabled";
    private static final String CONFIG_KEY_GUTTER = "GWC.gutter";
    private static final String CONFIG_KEY_GRIDSETS = "GWC.gridSets";
    private static final String CONFIG_KEY_METATILING_X = "GWC.metaTilingX";
    private static final String CONFIG_KEY_METATILING_Y = "GWC.metaTilingY";
    private static final String CONFIG_KEY_FORMATS = "GWC.cacheFormats";
    private static final String CONFIG_KEY_AUTO_CACHE_STYLES = "GWC.autoCacheStyles";
    private static final String CONFIG_KEY_CACHED_STYLES = "GWC.cachedNonDefaultStyles";
    private int gutter;
    private boolean enabled;
    private Set<String> cachedGridSetIds;
    private int metaTilingX;
    private int metaTilingY;
    private Set<String> mimeFormats;
    private boolean autoCacheStyles;
    private Set<String> cachedStyles;
    private boolean dirty;

    private static Set<String> unmarshalSet(String listStr) {
        HashSet<String> unmarshalled = new HashSet<String>(Arrays.asList(listStr.split(",")));
        return unmarshalled;
    }

    private static String marshalList(Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static GeoServerTileLayerInfo create(LayerInfo layerInfo, GWCConfig defaults) {
        Set alternateStyles;
        ResourceInfo resourceInfo = layerInfo.getResource();
        MetadataMap metadataMap = layerInfo.getMetadata();
        GeoServerTileLayerInfo info = GeoServerTileLayerInfo.create(metadataMap, defaults);
        if (metadataMap.containsKey((Object)CONFIG_KEY_FORMATS)) {
            String mimeFormatsStr = (String)metadataMap.get(CONFIG_KEY_FORMATS, String.class);
            Set<String> mimeFormats = GeoServerTileLayerInfo.unmarshalSet(mimeFormatsStr);
            info.setMimeFormats(mimeFormats);
        } else if (resourceInfo instanceof FeatureTypeInfo) {
            info.setMimeFormats(defaults.getDefaultVectorCacheFormats());
            info.setDirty(true);
        } else if (resourceInfo instanceof CoverageInfo) {
            info.setMimeFormats(defaults.getDefaultCoverageCacheFormats());
            info.setDirty(true);
        } else {
            info.setMimeFormats(defaults.getDefaultOtherCacheFormats());
            info.setDirty(true);
        }
        boolean autoCacheStyles = defaults.isCacheNonDefaultStyles();
        if (metadataMap.containsKey((Object)CONFIG_KEY_AUTO_CACHE_STYLES)) {
            autoCacheStyles = (Boolean)metadataMap.get(CONFIG_KEY_AUTO_CACHE_STYLES, Boolean.class);
        } else {
            info.setDirty(true);
        }
        info.setAutoCacheStyles(autoCacheStyles);
        info.setCachedStyles(Collections.EMPTY_SET);
        if (metadataMap.containsKey((Object)CONFIG_KEY_CACHED_STYLES)) {
            String cachedStylesStr = (String)metadataMap.get(CONFIG_KEY_CACHED_STYLES, String.class);
            Set<String> cachedStyles = GeoServerTileLayerInfo.unmarshalSet(cachedStylesStr);
            info.setCachedStyles(cachedStyles);
        } else if (autoCacheStyles && (alternateStyles = layerInfo.getStyles()) != null && alternateStyles.size() > 0) {
            HashSet<String> cachedStyles = new HashSet<String>();
            for (StyleInfo si : alternateStyles) {
                if (si == null) continue;
                cachedStyles.add(si.getName());
            }
            info.setCachedStyles(cachedStyles);
            info.setDirty(true);
        }
        return info;
    }

    public static GeoServerTileLayerInfo create(LayerGroupInfo layerInfo, GWCConfig defaults) {
        MetadataMap metadataMap = layerInfo.getMetadata();
        GeoServerTileLayerInfo info = GeoServerTileLayerInfo.create(metadataMap, defaults);
        if (metadataMap.containsKey((Object)CONFIG_KEY_FORMATS)) {
            String mimeFormatsStr = (String)metadataMap.get(CONFIG_KEY_FORMATS, String.class);
            Set<String> mimeFormats = GeoServerTileLayerInfo.unmarshalSet(mimeFormatsStr);
            info.setMimeFormats(mimeFormats);
        } else {
            info.setMimeFormats(defaults.getDefaultOtherCacheFormats());
            info.setDirty(true);
        }
        info.setCachedStyles(Collections.EMPTY_SET);
        return info;
    }

    private static GeoServerTileLayerInfo create(MetadataMap metadataMap, GWCConfig defaults) {
        GeoServerTileLayerInfo info = new GeoServerTileLayerInfo();
        boolean dirty = false;
        boolean enabled = defaults.isCacheLayersByDefault();
        if (metadataMap.containsKey((Object)CONFIG_KEY_ENABLED)) {
            enabled = (Boolean)metadataMap.get(CONFIG_KEY_ENABLED, Boolean.class);
        } else {
            dirty = true;
        }
        info.setEnabled(enabled);
        info.setGutter(defaults.getGutter());
        if (metadataMap.containsKey((Object)CONFIG_KEY_GUTTER)) {
            int gutter = (Integer)metadataMap.get(CONFIG_KEY_GUTTER, Integer.class);
            info.setGutter(gutter);
        } else {
            dirty = true;
        }
        info.setCachedGridSetIds(defaults.getDefaultCachingGridSetIds());
        if (metadataMap.containsKey((Object)CONFIG_KEY_GRIDSETS)) {
            String gridsets = (String)metadataMap.get(CONFIG_KEY_GRIDSETS, String.class);
            Set<String> gridSetIds = GeoServerTileLayerInfo.unmarshalSet(gridsets);
            info.setCachedGridSetIds(gridSetIds);
        } else {
            dirty = true;
        }
        info.setMetaTilingX(defaults.getMetaTilingX());
        info.setMetaTilingY(defaults.getMetaTilingY());
        if (metadataMap.containsKey((Object)CONFIG_KEY_METATILING_X)) {
            info.setMetaTilingX((Integer)metadataMap.get(CONFIG_KEY_METATILING_X, Integer.class));
        } else {
            dirty = true;
        }
        if (metadataMap.containsKey((Object)CONFIG_KEY_METATILING_Y)) {
            info.setMetaTilingY((Integer)metadataMap.get(CONFIG_KEY_METATILING_Y, Integer.class));
        } else {
            dirty = true;
        }
        info.setDirty(dirty);
        return info;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void saveTo(MetadataMap metadata) {
        boolean enabled = this.isEnabled();
        int gutter = this.getGutter();
        Set<String> cachedGridSetIds = this.getCachedGridSetIds();
        int metaTilingX = this.getMetaTilingX();
        int metaTilingY = this.getMetaTilingY();
        Set<String> mimeFormats = this.getMimeFormats();
        Set<String> cachedStyles = this.getCachedStyles();
        metadata.put(CONFIG_KEY_ENABLED, (Serializable)Boolean.valueOf(enabled));
        metadata.put(CONFIG_KEY_GUTTER, (Serializable)Integer.valueOf(gutter));
        metadata.put(CONFIG_KEY_GRIDSETS, (Serializable)((Object)GeoServerTileLayerInfo.marshalList(cachedGridSetIds)));
        metadata.put(CONFIG_KEY_METATILING_X, (Serializable)Integer.valueOf(metaTilingX));
        metadata.put(CONFIG_KEY_METATILING_Y, (Serializable)Integer.valueOf(metaTilingY));
        metadata.put(CONFIG_KEY_FORMATS, (Serializable)((Object)GeoServerTileLayerInfo.marshalList(mimeFormats)));
        metadata.put(CONFIG_KEY_AUTO_CACHE_STYLES, (Serializable)Boolean.valueOf(this.autoCacheStyles));
        if (cachedStyles.size() > 0) {
            metadata.put(CONFIG_KEY_CACHED_STYLES, (Serializable)((Object)GeoServerTileLayerInfo.marshalList(cachedStyles)));
        }
    }

    public Set<String> getCachedStyles() {
        return this.cachedStyles;
    }

    public void setCachedStyles(Set<String> cachedStyles) {
        this.cachedStyles = new HashSet<String>(cachedStyles);
    }

    public Set<String> getMimeFormats() {
        return this.mimeFormats;
    }

    public void setMimeFormats(Set<String> mimeFormats) {
        this.mimeFormats = new HashSet<String>(mimeFormats);
    }

    public int getMetaTilingX() {
        return this.metaTilingX;
    }

    public int getMetaTilingY() {
        return this.metaTilingY;
    }

    public void setMetaTilingY(int metaTilingY) {
        Assert.isTrue((metaTilingY > 0 ? 1 : 0) != 0);
        this.metaTilingY = metaTilingY;
    }

    public void setMetaTilingX(int metaTilingX) {
        Assert.isTrue((metaTilingX > 0 ? 1 : 0) != 0);
        this.metaTilingX = metaTilingX;
    }

    public void setCachedGridSetIds(Set<String> cachedGridSetIds) {
        this.cachedGridSetIds = cachedGridSetIds;
    }

    public Set<String> getCachedGridSetIds() {
        return this.cachedGridSetIds == null ? Collections.EMPTY_SET : this.cachedGridSetIds;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setGutter(int gutter) {
        this.gutter = gutter;
    }

    public int getGutter() {
        return this.gutter;
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean isAutoCacheStyles() {
        return this.autoCacheStyles;
    }

    public void setAutoCacheStyles(boolean autoCacheStyles) {
        this.autoCacheStyles = autoCacheStyles;
    }
}

