/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Iterator;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWCCatalogListener;
import org.geoserver.test.GeoServerTestSupport;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.wms.BBOX;

public class GWCCatalogListenerTest
extends GeoServerTestSupport {
    public void testInit() throws Exception {
        GWCCatalogListener gwcListener = (GWCCatalogListener)applicationContext.getBean("gwcCatalogListener");
        Catalog cat = gwcListener.cat;
        TileLayerDispatcher tld = gwcListener.layerDispatcher;
        try {
            tld.getTileLayer("");
        }
        catch (GeoWebCacheException gwce) {
            // empty catch block
        }
        List layerList = gwcListener.getTileLayers(true);
        Iterator tlIter = layerList.iterator();
        GWCCatalogListenerTest.assertTrue((boolean)tlIter.hasNext());
        if (tlIter.hasNext()) {
            return;
        }
        boolean foundLakes = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            if (!tl.getName().equals("cite:Lakes")) continue;
            tl.isInitialized();
            foundLakes = true;
            break;
        }
        GWCCatalogListenerTest.assertTrue((boolean)foundLakes);
        boolean foudAGF = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            System.out.println(tl.getName());
            if (!tl.getName().equals("sf:AggregateGeoFeature")) continue;
            tl.isInitialized();
            foudAGF = true;
            Grid epsg4326 = tl.getGrid(SRS.getEPSG4326());
            GWCCatalogListenerTest.assertTrue((boolean)epsg4326.getGridBounds().equals((Object)new BBOX(-180.0, -90.0, 180.0, 90.0)));
            String mime = ((MimeType)tl.getMimeTypes().get(1)).getMimeType();
            GWCCatalogListenerTest.assertTrue((mime.startsWith("image/") || mime.startsWith("application/vnd.google-earth.kml+xml") ? 1 : 0) != 0);
        }
        GWCCatalogListenerTest.assertTrue((boolean)foudAGF);
        LayerInfo li = (LayerInfo)cat.getLayers().get(1);
        String layerName = li.getResource().getPrefixedName();
        TileLayer tl = tld.getTileLayer(layerName);
        GWCCatalogListenerTest.assertEquals((String)layerName, (String)tl.getName());
        cat.remove(li);
        GWCCatalogListenerTest.assertTrue((cat.getLayerByName(tl.getName()) == null ? 1 : 0) != 0);
        boolean caughtException = false;
        try {
            TileLayer tl2 = tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException gwce) {
            caughtException = true;
        }
        GWCCatalogListenerTest.assertTrue((boolean)caughtException);
        LayerInfo layerInfo = cat.getFactory().createLayer();
        layerInfo.setName("hithere");
        ResourceInfo resInfo = li.getResource();
        resInfo.setName("hithere");
        resInfo.getNamespace().setPrefix("sf");
        layerInfo.setResource(resInfo);
        cat.add(layerInfo);
        TileLayer tl3 = tld.getTileLayer("sf:hithere");
        GWCCatalogListenerTest.assertEquals((String)tl3.getName(), (String)"sf:hithere");
    }
}

