/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.GridCalculator;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.Configuration;
import org.geowebcache.util.wms.BBOX;

public class GWCCatalogListener
implements CatalogListener,
Configuration {
    private static Logger log = Logging.getLogger((String)"org.geoserver.gwc");
    protected Catalog cat = null;
    protected TileLayerDispatcher layerDispatcher = null;
    private List<String> mimeFormats = null;
    private int[] metaFactors = new int[]{4, 4};
    private String wmsUrl = null;
    ArrayList<TileLayer> list;

    public GWCCatalogListener(Catalog cat, TileLayerDispatcher layerDispatcher, ApplicationContextProvider ctxProv) {
        this.cat = cat;
        this.layerDispatcher = layerDispatcher;
        this.mimeFormats = new ArrayList<String>(5);
        this.mimeFormats.add("image/png");
        this.mimeFormats.add("image/gif");
        this.mimeFormats.add("image/png8");
        this.mimeFormats.add("image/jpeg");
        this.mimeFormats.add("application/vnd.google-earth.kml+xml");
        this.wmsUrl = ctxProv.getSystemVar("GEOSERVER_WMS_URL", "http://localhost:8080/geoserver/wms");
        cat.addListener((CatalogListener)this);
        log.fine("GWCCatalogListener registered with catalog");
    }

    public void handleAddEvent(CatalogAddEvent event) {
        CatalogInfo obj = event.getSource();
        WMSLayer wmsLayer = null;
        if (obj instanceof CoverageInfo) {
            CoverageInfo covInfo = (CoverageInfo)obj;
            wmsLayer = this.getLayer(covInfo);
        }
        if (obj instanceof ResourceInfo) {
            ResourceInfo resInfo = (ResourceInfo)obj;
            wmsLayer = this.getLayer(resInfo);
        }
        if (wmsLayer != null && this.list != null) {
            this.addToList(wmsLayer);
            this.layerDispatcher.getLayers();
            this.layerDispatcher.add((TileLayer)wmsLayer);
            log.finer(wmsLayer.getName() + " added to TileLayerDispatcher");
        }
    }

    public void handleModifyEvent(CatalogModifyEvent event) {
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) {
        CatalogInfo obj = event.getSource();
        WMSLayer wmsLayer = null;
        if (obj instanceof CoverageInfo) {
            CoverageInfo covInfo = (CoverageInfo)obj;
            wmsLayer = this.getLayer(covInfo);
        }
        if (obj instanceof ResourceInfo) {
            ResourceInfo resInfo = (ResourceInfo)obj;
            wmsLayer = this.getLayer(resInfo);
        }
        if (wmsLayer != null && this.list != null) {
            this.removeFromList(wmsLayer);
            this.layerDispatcher.getLayers();
            this.layerDispatcher.remove(wmsLayer.getName());
            log.finer(wmsLayer.getName() + " removed from TileLayerDispatcher");
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) {
        CatalogInfo obj = event.getSource();
        WMSLayer wmsLayer = null;
        if (obj instanceof CoverageInfo) {
            CoverageInfo covInfo = (CoverageInfo)obj;
            wmsLayer = this.getLayer(covInfo);
        }
        if (obj instanceof ResourceInfo) {
            ResourceInfo resInfo = (ResourceInfo)obj;
            wmsLayer = this.getLayer(resInfo);
        }
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            wmsLayer = this.getLayer(lgInfo);
        }
        if (wmsLayer != null && this.list != null) {
            this.updateList(wmsLayer);
            this.layerDispatcher.getLayers();
            this.layerDispatcher.update((TileLayer)wmsLayer);
            log.finer(wmsLayer.getName() + " updated on TileLayerDispatcher");
        }
    }

    public void reloaded() {
        try {
            this.layerDispatcher.reInit();
        }
        catch (GeoWebCacheException gwce) {
            log.fine("Unable to reinit TileLayerDispatcher gwce.getMessage()");
        }
    }

    public String getIdentifier() throws GeoWebCacheException {
        return "GeoServer Catalog Listener";
    }

    public synchronized List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        if (!reload && this.list != null) {
            return this.list;
        }
        this.list = new ArrayList(this.cat.getLayers().size());
        for (LayerInfo li : this.cat.getLayers()) {
            WMSLayer tl = this.getLayer(li.getResource());
            this.list.add((TileLayer)tl);
        }
        for (LayerGroupInfo lgi : this.cat.getLayerGroups()) {
            WMSLayer tl = this.getLayer(lgi);
            this.list.add((TileLayer)tl);
        }
        log.fine("Responding with " + this.list.size() + " to getTileLayers() request from TileLayerDispatcher");
        return this.list;
    }

    private synchronized void updateList(WMSLayer wmsLayer) {
        if (this.list != null) {
            this.removeFromList(wmsLayer);
            this.addToList(wmsLayer);
        }
    }

    private synchronized void removeFromList(WMSLayer wmsLayer) {
        if (this.list != null) {
            Iterator<TileLayer> iter = this.list.iterator();
            int i = 0;
            while (iter.hasNext()) {
                TileLayer tl = iter.next();
                if (tl.getName().equals(wmsLayer.getName())) {
                    this.list.remove(i);
                }
                ++i;
            }
        }
    }

    private synchronized void addToList(WMSLayer wmsLayer) {
        if (this.list != null) {
            this.list.add((TileLayer)wmsLayer);
        }
    }

    private WMSLayer getLayer(LayerGroupInfo lgi) {
        ReferencedEnvelope latLonBounds = null;
        try {
            latLonBounds = lgi.getBounds().transform(CRS.decode((String)"EPSG:4326"), true);
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
        if (latLonBounds == null) {
            log.fine("GWCCatalogListener had problems reprojecting " + lgi.getBounds() + " to EPSG:4326");
        }
        WMSLayer retLayer = new WMSLayer(lgi.getName(), this.getWMSUrl(), null, lgi.getName(), this.mimeFormats, this.getGrids(latLonBounds), this.metaFactors, null, true);
        retLayer.setBackendTimeout(120);
        return retLayer;
    }

    private WMSLayer getLayer(ResourceInfo fti) {
        WMSLayer retLayer = new WMSLayer(fti.getPrefixedName(), this.getWMSUrl(), null, fti.getPrefixedName(), this.mimeFormats, this.getGrids(fti.getLatLonBoundingBox()), this.metaFactors, null, true);
        retLayer.setBackendTimeout(120);
        return retLayer;
    }

    private WMSLayer getLayer(CoverageInfo ci) {
        WMSLayer retLayer = new WMSLayer(ci.getPrefixedName(), this.getWMSUrl(), null, ci.getPrefixedName(), this.mimeFormats, this.getGrids(ci.getLatLonBoundingBox()), this.metaFactors, null, false);
        retLayer.setBackendTimeout(120);
        return retLayer;
    }

    private String[] getWMSUrl() {
        String[] strs = new String[]{this.wmsUrl};
        return strs;
    }

    private Hashtable<SRS, Grid> getGrids(ReferencedEnvelope env) {
        double minX = env.getMinX();
        double minY = env.getMinY();
        double maxX = env.getMaxX();
        double maxY = env.getMaxY();
        BBOX bounds4326 = new BBOX(minX, minY, maxX, maxY);
        BBOX bounds900913 = new BBOX(this.longToSphericalMercatorX(minX), this.latToSphericalMercatorY(minY), this.longToSphericalMercatorX(maxX), this.latToSphericalMercatorY(maxY));
        Hashtable<SRS, Grid> grids = new Hashtable<SRS, Grid>(2);
        grids.put(SRS.getEPSG4326(), new Grid(SRS.getEPSG4326(), bounds4326, BBOX.WORLD4326, GridCalculator.get4326Resolutions()));
        grids.put(SRS.getEPSG900913(), new Grid(SRS.getEPSG900913(), bounds900913, BBOX.WORLD900913, GridCalculator.get900913Resolutions()));
        return grids;
    }

    private double longToSphericalMercatorX(double x) {
        return x / 180.0 * 2.003750834E7;
    }

    private double latToSphericalMercatorY(double y) {
        if (y > 85.05112) {
            y = 85.05112;
        }
        if (y < -85.05112) {
            y = -85.05112;
        }
        y = Math.PI / 180 * y;
        double tmp = 0.7853981633974483 + y / 2.0;
        return 2.003750834E7 * Math.log(Math.tan(tmp)) / Math.PI;
    }
}

