/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.geotools.util.logging.Logging;

public class EMFLogger
implements MethodInterceptor {
    Logger logger;

    public EMFLogger(String logPackage) {
        this.logger = Logging.getLogger((String)logPackage);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer log = new StringBuffer();
        log.append("\nRequest: " + invocation.getMethod().getName());
        if (invocation.getArguments().length > 0) {
            EObject requestBean = null;
            int i = 0;
            while (i < invocation.getArguments().length) {
                Object argument = invocation.getArguments()[i];
                if (argument instanceof EObject) {
                    requestBean = (EObject)argument;
                    break;
                }
                ++i;
            }
            if (requestBean != null) {
                this.log(requestBean, 1, log);
            }
        }
        Object result = invocation.proceed();
        this.logger.info(log.toString());
        return result;
    }

    void log(EObject object, int level, StringBuffer log) {
        EList properties = object.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature property : properties) {
            Object value = object.eGet(property);
            log.append("\n");
            int i = 0;
            while (i < level) {
                log.append("\t");
                ++i;
            }
            log.append(property.getName());
            if (value instanceof EObject && level < 2) {
                log.append(":");
                this.log((EObject)value, level + 1, log);
                continue;
            }
            log.append(" = " + value);
        }
    }
}

