/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import net.opengis.ows10.AcceptVersionsType;
import net.opengis.ows10.GetCapabilitiesType;
import net.opengis.ows10.Ows10Factory;
import org.geoserver.ows.XmlObjectEncodingResponse;
import org.geoserver.ows.xml.v1_0.OWSConfiguration;
import org.w3c.dom.Document;

public class XmlObjectEncodingResponseTest
extends TestCase {
    XmlObjectEncodingResponse response;

    protected void setUp() throws Exception {
        this.response = new XmlObjectEncodingResponse(GetCapabilitiesType.class, "GetCapabilities", OWSConfiguration.class);
    }

    public void testCanHandle() {
        XmlObjectEncodingResponseTest.assertTrue((boolean)this.response.canHandle(null));
    }

    public void testGetMimeType() {
        XmlObjectEncodingResponseTest.assertEquals((String)"application/xml", (String)this.response.getMimeType(null, null));
    }

    public void testEncode() throws Exception {
        Ows10Factory f = Ows10Factory.eINSTANCE;
        GetCapabilitiesType caps = f.createGetCapabilitiesType();
        AcceptVersionsType versions = f.createAcceptVersionsType();
        caps.setAcceptVersions(versions);
        versions.getVersion().add((Object)"1.0.0");
        versions.getVersion().add((Object)"1.1.0");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.response.write((Object)caps, (OutputStream)output, null);
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new ByteArrayInputStream(output.toByteArray())), new DOMResult(d));
        XmlObjectEncodingResponseTest.assertEquals((String)"ows:GetCapabilities", (String)d.getDocumentElement().getNodeName());
        XmlObjectEncodingResponseTest.assertEquals((int)2, (int)d.getElementsByTagName("ows:Version").getLength());
    }
}

