/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.w3c.dom.Document;

public class RestletTestSupport
extends TestCase {
    protected XpathEngine xp;

    protected void setUp() throws Exception {
        super.setUp();
        this.xp = XMLUnit.newXpathEngine();
    }

    protected Request newRequestGET(String path) {
        Request request = new Request();
        request.setMethod(Method.GET);
        request.setResourceRef("http://localhost/" + path);
        return request;
    }

    protected Request newRequestPOST(String path, String body, String contentType) {
        Request request = new Request();
        request.setMethod(Method.POST);
        request.setResourceRef("http://localhost/" + path);
        request.setEntity((Representation)new InputRepresentation((InputStream)new ByteArrayInputStream(body.getBytes()), new MediaType(contentType)));
        return request;
    }

    protected Request newRequestPUT(String path, String body, String contentType) {
        Request request = this.newRequestPOST(path, body, contentType);
        request.setMethod(Method.PUT);
        return request;
    }

    protected Document getDOM(Response response) throws Exception {
        return response.getEntityAsDom().getDocument();
    }

    protected JSON getJSON(Response response) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getStream()));
        StringBuffer json = new StringBuffer();
        String line = null;
        while ((line = in.readLine()) != null) {
            json.append(line);
        }
        in.close();
        return JSONSerializer.toJSON((Object)json.toString());
    }

    protected void print(Document dom) throws Exception {
        TransformerFactory txFactory = TransformerFactory.newInstance();
        try {
            txFactory.setAttribute("{http://xml.apache.org/xalan}indent-number", new Integer(2));
        }
        catch (Exception e) {
            // empty catch block
        }
        Transformer tx = txFactory.newTransformer();
        tx.setOutputProperty("method", "xml");
        tx.setOutputProperty("indent", "yes");
        tx.transform(new DOMSource(dom), new StreamResult(new OutputStreamWriter((OutputStream)System.out, "utf-8")));
    }
}

