/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.geoserver.rest.util.IOUtils;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public class RESTUtils {
    static Set<String> ZIP_MIME_TYPES = new HashSet<String>();

    static {
        ZIP_MIME_TYPES.add("application/zip");
        ZIP_MIME_TYPES.add("multipart/x-zip");
        ZIP_MIME_TYPES.add("application/x-zip-compressed");
    }

    public static HttpServletRequest getServletRequest(Request request) {
        HttpRequest httpRequest;
        if (request instanceof HttpRequest && (httpRequest = (HttpRequest)request).getHttpCall() instanceof ServletCall) {
            ServletCall call = (ServletCall)httpRequest.getHttpCall();
            return call.getRequest();
        }
        return null;
    }

    public static String getBaseURL(Request request) {
        Reference ref = request.getResourceRef();
        HttpServletRequest servletRequest = RESTUtils.getServletRequest(request);
        if (servletRequest != null) {
            String baseURL = ref.getIdentifier();
            return baseURL.substring(0, baseURL.length() - servletRequest.getPathInfo().length());
        }
        return ref.getParentRef().getIdentifier();
    }

    public static File handleBinUpload(String datasetName, String extension, Request request) throws IOException, ConfigurationException {
        File dir = GeoserverDataDirectory.findCreateConfigDir((String)"data");
        return RESTUtils.handleBinUpload(String.valueOf(datasetName) + "." + extension, dir, request);
    }

    public static File handleBinUpload(String fileName, File directory, Request request) throws IOException {
        File newFile = new File(directory, fileName);
        if (newFile.exists()) {
            FileUtils.cleanDirectory((File)directory);
        }
        ReadableByteChannel source = request.getEntity().getChannel();
        FileChannel outputChannel = IOUtils.getOuputChannel(newFile);
        IOUtils.copyChannel(0x100000, source, outputChannel);
        IOUtils.closeQuietly(source);
        IOUtils.closeQuietly(outputChannel);
        return newFile;
    }

    public static File handleURLUpload(String datasetName, String extension, Request request) throws IOException, ConfigurationException {
        File dir = GeoserverDataDirectory.findCreateConfigDir((String)"data");
        return RESTUtils.handleURLUpload(String.valueOf(datasetName) + "." + extension, dir, request);
    }

    public static File handleURLUpload(String fileName, File directory, Request request) throws IOException {
        File newFile = new File(directory, fileName);
        InputStream inStream = request.getEntity().getStream();
        String stringURL = IOUtils.getStringFromStream(inStream);
        URL fileURL = new URL(stringURL);
        File inputFile = IOUtils.URLToFile(fileURL);
        if (inputFile != null && inputFile.exists() && inputFile.canRead()) {
            IOUtils.copyFile(inputFile, newFile);
        } else {
            InputStream inputStream = fileURL.openStream();
            FileOutputStream outStream = new FileOutputStream(newFile);
            IOUtils.copyStream(inputStream, outStream, true, true);
        }
        return newFile;
    }

    public static File handleEXTERNALUpload(Request request) throws IOException {
        InputStream inStream = request.getEntity().getStream();
        String stringURL = IOUtils.getStringFromStream(inStream);
        URL fileURL = new URL(stringURL);
        File inputFile = IOUtils.URLToFile(fileURL);
        if (inputFile != null && inputFile.exists() && inputFile.canRead()) {
            return inputFile;
        }
        return null;
    }

    public static boolean isZipMediaType(MediaType mediaType) {
        return ZIP_MIME_TYPES.contains(mediaType.toString());
    }

    public static void unzipFile(File zipFile, File outputDirectory) throws IOException {
        if (outputDirectory == null) {
            outputDirectory = zipFile.getParentFile();
        }
        if (outputDirectory != null && !outputDirectory.exists()) {
            outputDirectory.mkdir();
        }
        ZipFile archive = new ZipFile(zipFile);
        IOUtils.inflate(archive, outputDirectory, null);
        IOUtils.deleteFile(zipFile);
    }

    public static File unpackZippedDataset(String storeName, File zipFile) throws IOException, ConfigurationException {
        File outputDirectory = new File(GeoserverDataDirectory.findCreateConfigDir((String)"data"), storeName);
        RESTUtils.unzipFile(zipFile, outputDirectory);
        return outputDirectory;
    }

    public static String getAttribute(Request request, String name) {
        Object o = request.getAttributes().get(name);
        return RESTUtils.decode(o);
    }

    public static String getQueryStringValue(Request request, String key) {
        String value = request.getResourceRef().getQueryAsForm().getFirstValue(key);
        return RESTUtils.decode(value);
    }

    static String decode(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

