/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.rest.FooMapResource;
import org.geoserver.rest.RestletTestSupport;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.w3c.dom.Document;

public class MapResourceTest
extends RestletTestSupport {
    public void testMapGET() throws Exception {
        Request request = this.newRequestGET("foo.xml");
        Response response = new Response(request);
        FooMapResource resource = new FooMapResource(null, request, response);
        resource.handleGet();
        Document dom = this.getDOM(response);
        MapResourceTest.assertEquals((String)"root", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"one", (String)"//prop1", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//prop2", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3.0", (String)"//prop3", (Document)dom);
    }

    public void testObjectPOST() throws Exception {
        String xml = "<org.geoserver.rest.Foo><prop1>one</prop1><prop2>2</prop2><prop3>3.0</prop3></org.geoserver.rest.Foo>";
        Request request = this.newRequestPOST("foo", xml, "text/xml");
        Response response = new Response(request);
        FooMapResource resource = new FooMapResource(null, request, response);
        resource.handlePost();
        MapResourceTest.assertEquals((Object)"one", resource.posted.get("prop1"));
        MapResourceTest.assertEquals((Object)"2", resource.posted.get("prop2"));
        MapResourceTest.assertEquals((Object)"3.0", resource.posted.get("prop3"));
    }

    public void testObjectPUT() throws Exception {
        String xml = "<root><prop1>one</prop1><prop2>2</prop2><prop3>3.0</prop3></root>";
        Request request = this.newRequestPOST("foo", xml, "text/xml");
        Response response = new Response(request);
        FooMapResource resource = new FooMapResource(null, request, response);
        resource.handlePut();
        MapResourceTest.assertEquals((Object)"one", resource.puted.get("prop1"));
        MapResourceTest.assertEquals((Object)"2", resource.puted.get("prop2"));
        MapResourceTest.assertEquals((Object)"3.0", resource.puted.get("prop3"));
    }
}

