/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.VectorType;
import net.opengis.gml.impl.TimePositionTypeImpl;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.DescribeCoverageType;
import net.opengis.wcs10.DomainSubsetType;
import net.opengis.wcs10.GetCapabilitiesType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.InterpolationMethodType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.OutputType;
import net.opengis.wcs10.RangeSubsetType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.TypedLiteralType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.response.Wcs10CapsTransformer;
import org.geoserver.wcs.response.Wcs10DescribeCoverageTransformer;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebCoverageService100
implements WebCoverageService100 {
    private Catalog catalog;
    private GeoServer geoServer;
    private static final Logger LOGGER = Logging.getLogger(DefaultWebCoverageService100.class);

    public DefaultWebCoverageService100(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
    }

    public WCSInfo getServiceInfo() {
        return (WCSInfo)this.geoServer.getService(WCSInfo.class);
    }

    @Override
    public Wcs10CapsTransformer getCapabilities(GetCapabilitiesType request) {
        String version;
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.0.0");
        ArrayList<String> accepted = null;
        if (request.getVersion() != null) {
            accepted = new ArrayList<String>();
            accepted.add(request.getVersion());
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            Wcs10CapsTransformer capsTransformer = new Wcs10CapsTransformer(this.geoServer);
            capsTransformer.setEncoding(Charset.forName(this.getServiceInfo().getGeoServer().getGlobal().getCharset()));
            return capsTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public Wcs10DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        String version = request.getVersion();
        if ("1.0.0".equals(version)) {
            WCSInfo wcs = this.getServiceInfo();
            Wcs10DescribeCoverageTransformer describeTransformer = new Wcs10DescribeCoverageTransformer(wcs, this.catalog);
            describeTransformer.setEncoding(Charset.forName(wcs.getGeoServer().getGlobal().getCharset()));
            return describeTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public GridCoverage[] getCoverage(GetCoverageType request) {
        WCSInfo wcs = this.getServiceInfo();
        CoverageInfo meta = null;
        GridCoverage2D coverage = null;
        ArrayList<GridCoverage2D> coverageResults = new ArrayList<GridCoverage2D>();
        try {
            boolean hasElevation;
            ParameterValueGroup readParametersDescriptor;
            GeneralParameterValue[] readParameters;
            Rectangle destinationSize;
            AffineTransform2D destinationG2W;
            CoordinateReferenceSystem targetCRS;
            meta = this.catalog.getCoverageByName(request.getSourceCoverage());
            if (meta == null) {
                throw new WcsException("Cannot find sourceCoverage on the catalog!");
            }
            DefaultWebCoverageService100.checkRangeSubset(meta, request.getRangeSubset());
            DefaultWebCoverageService100.checkInterpolationMethod(meta, request.getInterpolationMethod());
            DefaultWebCoverageService100.checkOutput(meta, request.getOutput());
            DomainSubsetType domainSubset = request.getDomainSubset();
            TimeSequenceType temporalSubset = domainSubset.getTemporalSubset();
            SpatialSubsetType spatialSubset = domainSubset.getSpatialSubset();
            EList grids = spatialSubset.getGrid();
            if (grids.size() == 0) {
                throw new IllegalArgumentException("Invalid number of Grid for spatial subsetting was set:" + grids.size());
            }
            RectifiedGridType grid = (RectifiedGridType)grids.get(0);
            EList envelopes = spatialSubset.getEnvelope();
            if (envelopes.size() == 0) {
                throw new IllegalArgumentException("Invalid number of Envelope for spatial subsetting was set:" + envelopes.size());
            }
            GeneralEnvelope requestedEnvelope = (GeneralEnvelope)envelopes.get(0);
            OutputType output = request.getOutput();
            if (output == null) {
                throw new IllegalArgumentException("Output type was null");
            }
            CodeType outputCRS = output.getCrs();
            int dimension = grid.getDimension().intValue();
            if (dimension == 3) {
                throw new WcsException("We support a third dimension only via a specifica Axis in Range", WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)meta.getGridCoverageReader(null, WCSUtils.getReaderHints((WCSInfo)wcs));
            if (reader == null) {
                return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
            }
            GeneralEnvelope nativeEnvelope = reader.getOriginalEnvelope();
            CoordinateReferenceSystem nativeCRS = nativeEnvelope.getCoordinateReferenceSystem();
            String requestedCRS = null;
            if (outputCRS != null) {
                requestedCRS = outputCRS.getValue();
            }
            if (requestedCRS == null) {
                targetCRS = reader.getOriginalEnvelope().getCoordinateReferenceSystem();
                requestedCRS = CRS.lookupIdentifier((IdentifiedObject)targetCRS, (boolean)true);
            } else {
                targetCRS = CRS.decode((String)requestedCRS, (boolean)true);
            }
            GridEnvelope limits = grid.getLimits();
            if (limits != null) {
                int[] lowers = limits.getLow().getCoordinateValues();
                destinationG2W = null;
                destinationSize = new Rectangle(lowers[0], lowers[1], limits.getSpan(0), limits.getSpan(1));
            } else if (grid.getOffsetVector() != null && grid.getOffsetVector().size() > 0) {
                VectorType offsetVector = (VectorType)grid.getOffsetVector().get(0);
                List offsetValues = offsetVector.getValue();
                double resX = (Double)offsetValues.get(0);
                double resY = (Double)offsetValues.get(1);
                DirectPositionType origin_ = grid.getOrigin().getPos();
                destinationSize = null;
                destinationG2W = new AffineTransform2D(resX, 0.0, 0.0, resY, ((Double)origin_.getValue().get(0)).doubleValue(), ((Double)origin_.getValue().get(1)).doubleValue());
            } else {
                throw new WcsException("Invalid Grid value:" + grid.toString(), WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            double[] elevations = null;
            EList axisSubset = null;
            if (request.getRangeSubset() != null && (axisSubset = request.getRangeSubset().getAxisSubset()).size() > 0) {
                int a = 0;
                while (a < axisSubset.size()) {
                    AxisSubsetType axis = (AxisSubsetType)axisSubset.get(a);
                    String axisName = axis.getName();
                    if (axisName.equalsIgnoreCase("ELEVATION")) {
                        if (axis.getSingleValue().size() > 0) {
                            elevations = new double[axis.getSingleValue().size()];
                            int s = 0;
                            while (s < axis.getSingleValue().size()) {
                                elevations[s] = Double.parseDouble(((TypedLiteralType)axis.getSingleValue().get(s)).getValue());
                                ++s;
                            }
                        } else if (axis.getInterval().size() > 0) {
                            IntervalType interval = (IntervalType)axis.getInterval().get(0);
                            int min = Integer.parseInt(interval.getMin().getValue());
                            int max = Integer.parseInt(interval.getMax().getValue());
                            int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                            elevations = new double[(int)(Math.floor(max - min) / (double)res + 1.0)];
                            int b = 0;
                            while (b < elevations.length) {
                                elevations[b] = min + b * res;
                                ++b;
                            }
                        }
                    }
                    ++a;
                }
            }
            LinkedList<Date> timeValues = new LinkedList<Date>();
            if (temporalSubset != null && temporalSubset.getTimePosition() != null && temporalSubset.getTimePosition().size() > 0) {
                EList timePositionLists = temporalSubset.getTimePosition();
                for (TimePositionTypeImpl tp : timePositionLists) {
                    timeValues.add((Date)tp.getValue());
                }
            }
            readParameters = (readParameters = CoverageUtils.getParameters((ParameterValueGroup)(readParametersDescriptor = reader.getFormat().getReadParameters()), (Map)meta.getParameters())) != null ? readParameters : new GeneralParameterValue[]{};
            GridGeometry2D requestedGridGeometry = destinationSize != null ? new GridGeometry2D((GridEnvelope)new GridEnvelope2D(destinationSize), DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope)) : new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)destinationG2W, DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope), null);
            ParameterValue requestedGridGeometryParam = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GeneralGridGeometry.class, null, (Object)requestedGridGeometry).createValue();
            List parameterDescriptors = readParametersDescriptor.getDescriptor().descriptors();
            ParameterValue time = null;
            boolean hasTime = timeValues.size() > 0;
            ParameterValue elevation = null;
            boolean bl = hasElevation = elevations != null && !Double.isNaN(elevations[0]);
            if (hasElevation || hasTime) {
                for (GeneralParameterDescriptor pd : parameterDescriptors) {
                    String code = pd.getName().getCode();
                    if (code.equalsIgnoreCase("TIME")) {
                        time = (ParameterValue)pd.createValue();
                        time.setValue(timeValues);
                    }
                    if (code.equalsIgnoreCase("ELEVATION")) {
                        elevation = (ParameterValue)pd.createValue();
                        elevation.setValue(elevations[0]);
                    }
                    if (hasElevation && elevation != null && hasTime && time != null || !hasElevation && hasTime && time != null || hasElevation && elevation != null && !hasTime) break;
                }
            }
            int addedParams = 1 + (hasTime ? 1 : 0) + (hasElevation ? 1 : 0);
            GeneralParameterValue[] readParametersClone = new GeneralParameterValue[readParameters.length + addedParams--];
            System.arraycopy(readParameters, 0, readParametersClone, 0, readParameters.length);
            readParametersClone[readParameters.length + addedParams--] = requestedGridGeometryParam;
            if (hasTime) {
                readParametersClone[readParameters.length + addedParams--] = time;
            }
            if (hasElevation) {
                readParametersClone[readParameters.length + addedParams--] = elevation;
            }
            readParameters = readParametersClone;
            WCSUtils.checkInputLimits((WCSInfo)wcs, (CoverageInfo)meta, (AbstractGridCoverage2DReader)reader, (GridGeometry2D)requestedGridGeometry);
            coverage = reader.read(readParameters);
            if (coverage == null || !(coverage instanceof GridCoverage2D)) {
                throw new IOException("The requested coverage could not be found.");
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
            GridCoverage2D bandSelectedCoverage = coverage;
            String interpolationType = null;
            if (request.getRangeSubset() != null) {
                interpolationType = request.getInterpolationMethod().getLiteral();
                axisSubset = request.getRangeSubset().getAxisSubset();
                if (axisSubset.size() > 0) {
                    int a = 0;
                    while (a < axisSubset.size()) {
                        block50: {
                            AxisSubsetType axis = (AxisSubsetType)axisSubset.get(a);
                            try {
                                String axisName = axis.getName();
                                if (!axisName.equalsIgnoreCase("Band")) break block50;
                                int[] bands = null;
                                if (axis.getSingleValue().size() > 0) {
                                    bands = new int[axis.getSingleValue().size()];
                                    int s = 0;
                                    while (s < axis.getSingleValue().size()) {
                                        bands[s] = Integer.parseInt(((TypedLiteralType)axis.getSingleValue().get(s)).getValue()) - 1;
                                        ++s;
                                    }
                                } else if (axis.getInterval().size() > 0) {
                                    IntervalType interval = (IntervalType)axis.getInterval().get(0);
                                    int min = Integer.parseInt(interval.getMin().getValue());
                                    int max = Integer.parseInt(interval.getMax().getValue());
                                    int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                                    bands = new int[(int)(Math.floor(max - min) / (double)res + 1.0)];
                                    int b = 0;
                                    while (b < bands.length) {
                                        bands[b] = min + b * res - 1;
                                        ++b;
                                    }
                                }
                                bandSelectedCoverage = (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])bands);
                            }
                            catch (Exception e) {
                                throw new WcsException("Band Select Operation: " + e.getLocalizedMessage());
                            }
                        }
                        ++a;
                    }
                }
            }
            Interpolation interpolation = Interpolation.getInstance((int)0);
            if (interpolationType != null) {
                if (interpolationType.equalsIgnoreCase("bilinear")) {
                    interpolation = Interpolation.getInstance((int)1);
                } else if (interpolationType.equalsIgnoreCase("bicubic")) {
                    interpolation = Interpolation.getInstance((int)2);
                } else if (interpolationType.equalsIgnoreCase("nearest neighbor")) {
                    interpolation = Interpolation.getInstance((int)0);
                }
            }
            GeneralEnvelope destinationEnvelope = (GeneralEnvelope)DefaultWebCoverageService100.getHorizontalEnvelope(DefaultWebCoverageService100.computeIntersectionEnvelope(requestedEnvelope, nativeEnvelope));
            if (targetCRS != null) {
                MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS);
                destinationEnvelope = CRS.transform((MathTransform)mt, (Envelope)destinationEnvelope);
                destinationEnvelope.setCoordinateReferenceSystem(targetCRS);
            }
            GridGeometry2D destinationGridGeometry = destinationSize != null ? new GridGeometry2D((GridEnvelope)new GridEnvelope2D(destinationSize), (Envelope)destinationEnvelope) : new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)destinationG2W, (Envelope)destinationEnvelope, null);
            WCSUtils.checkOutputLimits((WCSInfo)wcs, (GridEnvelope2D)destinationGridGeometry.getGridRange2D(), (SampleModel)bandSelectedCoverage.getRenderedImage().getSampleModel());
            GridCoverage2D finalCoverage = WCSUtils.resample((GridCoverage2D)bandSelectedCoverage, (CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS, (GridGeometry2D)destinationGridGeometry, (Interpolation)interpolation);
            coverageResults.add(finalCoverage);
            return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
        }
        catch (Exception e) {
            if (e instanceof WcsException) {
                throw (WcsException)e;
            }
            throw new WcsException((Throwable)e);
        }
    }

    private static Envelope getHorizontalEnvelope(GeneralEnvelope requestedEnvelope) {
        if (requestedEnvelope == null) {
            return null;
        }
        SingleCRS nativeCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelope.getCoordinateReferenceSystem());
        GeneralEnvelope horizontalRequestedEnvelope = new GeneralEnvelope((CoordinateReferenceSystem)nativeCRS);
        horizontalRequestedEnvelope.setEnvelope(new double[]{requestedEnvelope.getLowerCorner().getOrdinate(0), requestedEnvelope.getLowerCorner().getOrdinate(1), requestedEnvelope.getUpperCorner().getOrdinate(0), requestedEnvelope.getUpperCorner().getOrdinate(1)});
        return horizontalRequestedEnvelope;
    }

    private static GeneralEnvelope computeIntersectionEnvelope(GeneralEnvelope requestedEnvelope, GeneralEnvelope nativeEnvelope) {
        block18: {
            GeneralEnvelope requestedBBOXInNativeGeographicCRS;
            GeneralEnvelope nativeGeoEnvelope;
            GeographicCRS nativeGeoCRS;
            SingleCRS requestCRS;
            block17: {
                MathTransform requestCRSToCoverageGeographicCRS2D;
                SingleCRS nativeCRS;
                block16: {
                    GeneralEnvelope retVal;
                    block15: {
                        requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelope.getCoordinateReferenceSystem());
                        nativeCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)nativeEnvelope.getCoordinateReferenceSystem());
                        MathTransform destinationToSourceTransform = null;
                        if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                            destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)requestCRS, (CoordinateReferenceSystem)nativeCRS, (boolean)true);
                        }
                        if (destinationToSourceTransform != null && !destinationToSourceTransform.isIdentity()) {
                            retVal = CRS.transform((MathTransform)destinationToSourceTransform, (Envelope)DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope));
                            retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
                        } else {
                            retVal = new GeneralEnvelope(DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope));
                        }
                        if (retVal.intersects((Envelope)nativeEnvelope, true)) break block15;
                        return null;
                    }
                    try {
                        retVal.intersect((Envelope)nativeEnvelope);
                        retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
                        return retVal;
                    }
                    catch (TransformException te) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                        }
                    }
                    catch (FactoryException fe) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block16;
                        LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
                    }
                }
                nativeGeoCRS = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)nativeCRS);
                nativeGeoEnvelope = (GeneralEnvelope)CRS.transform((Envelope)nativeEnvelope, (CoordinateReferenceSystem)nativeGeoCRS);
                nativeGeoEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
                requestedBBOXInNativeGeographicCRS = null;
                if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)requestCRS) && !(requestCRSToCoverageGeographicCRS2D = CRS.findMathTransform((CoordinateReferenceSystem)requestCRS, (CoordinateReferenceSystem)nativeGeoCRS, (boolean)true)).isIdentity()) {
                    requestedBBOXInNativeGeographicCRS = CRS.transform((MathTransform)requestCRSToCoverageGeographicCRS2D, (Envelope)requestedEnvelope);
                    requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
                }
                if (requestedBBOXInNativeGeographicCRS == null) {
                    requestedBBOXInNativeGeographicCRS = new GeneralEnvelope((CoordinateReferenceSystem)requestCRS);
                }
                if (requestedBBOXInNativeGeographicCRS.intersects((Envelope)nativeEnvelope, true)) break block17;
                return null;
            }
            try {
                requestedBBOXInNativeGeographicCRS.intersect((Envelope)nativeGeoEnvelope);
                requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)nativeGeoCRS, (CoordinateReferenceSystem)requestCRS, (boolean)true);
                GeneralEnvelope approximateRequestedBBox = CRS.transform((MathTransform)transform, (Envelope)requestedBBOXInNativeGeographicCRS);
                approximateRequestedBBox.setCoordinateReferenceSystem((CoordinateReferenceSystem)requestCRS);
                return approximateRequestedBBox;
            }
            catch (TransformException te) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
            }
            catch (FactoryException fe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block18;
                LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
            }
        }
        LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
        return null;
    }

    private static void checkInterpolationMethod(CoverageInfo info, InterpolationMethodType interpolationMethod) {
        String interpolation = interpolationMethod.getLiteral();
        if (interpolation != null) {
            boolean interpolationSupported = false;
            if (interpolation.startsWith("nearest")) {
                interpolation = "nearest neighbor";
            }
            if (interpolation.equals("nearest neighbor") || info.getDefaultInterpolationMethod() != null && info.getDefaultInterpolationMethod().equalsIgnoreCase(interpolation)) {
                interpolationSupported = true;
            }
            for (String method : info.getInterpolationMethods()) {
                if (!interpolation.equalsIgnoreCase(method)) continue;
                interpolationSupported = true;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
    }

    private static void checkOutput(CoverageInfo meta, OutputType output) {
        if (output == null) {
            return;
        }
        String format = output.getFormat().getValue();
        String declaredFormat = DefaultWebCoverageService100.getDeclaredFormat(meta.getSupportedFormats(), format);
        if (declaredFormat == null) {
            throw new WcsException("format " + format + " is not supported for this coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
    }

    private static String getDeclaredFormat(List<String> supportedFormats, String format) {
        for (String sf : supportedFormats) {
            if (sf.equalsIgnoreCase(format.trim())) {
                return sf;
            }
            CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)sf);
            if (delegate == null || !delegate.canProduce(format)) continue;
            return sf;
        }
        return null;
    }

    private static void checkRangeSubset(CoverageInfo info, RangeSubsetType rangeSubset) {
        if (rangeSubset == null) {
            return;
        }
        if (rangeSubset.getAxisSubset().size() > 1) {
            throw new WcsException("Multi axis coverages are not supported yet", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        if (rangeSubset.getAxisSubset().size() == 0) {
            return;
        }
        int a = 0;
        while (a < rangeSubset.getAxisSubset().size()) {
            int b;
            int res;
            int max;
            int min;
            IntervalType interval;
            AxisSubsetType axisSubset = (AxisSubsetType)rangeSubset.getAxisSubset().get(a);
            if (axisSubset.getName().equalsIgnoreCase("Band")) {
                int[] bands = null;
                if (axisSubset.getSingleValue().size() > 0) {
                    bands = new int[]{Integer.parseInt(((TypedLiteralType)axisSubset.getSingleValue().get(0)).getValue())};
                } else if (axisSubset.getInterval().size() > 0) {
                    interval = (IntervalType)axisSubset.getInterval().get(0);
                    min = Integer.parseInt(interval.getMin().getValue());
                    max = Integer.parseInt(interval.getMax().getValue());
                    res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                    bands = new int[(max - min) / res];
                    b = 0;
                    while (b < bands.length) {
                        bands[b] = min + b * res;
                        ++b;
                    }
                }
                if (bands == null) {
                    throw new WcsException("Invalid values for axis " + axisSubset.getName(), WcsException.WcsExceptionCode.InvalidParameterValue, "AxisSubset");
                }
            } else if (axisSubset.getName().equalsIgnoreCase("ELEVATION")) {
                double[] elevations = null;
                if (axisSubset.getSingleValue().size() > 0) {
                    elevations = new double[axisSubset.getSingleValue().size()];
                    int s = 0;
                    while (s < axisSubset.getSingleValue().size()) {
                        elevations[s] = Double.parseDouble(((TypedLiteralType)axisSubset.getSingleValue().get(s)).getValue());
                        ++s;
                    }
                } else if (axisSubset.getInterval().size() > 0) {
                    interval = (IntervalType)axisSubset.getInterval().get(0);
                    min = Integer.parseInt(interval.getMin().getValue());
                    max = Integer.parseInt(interval.getMax().getValue());
                    res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                    elevations = new double[(int)(Math.floor(max - min) / (double)res + 1.0)];
                    b = 0;
                    while (b < elevations.length) {
                        elevations[b] = min + b * res;
                        ++b;
                    }
                }
            }
            ++a;
        }
    }
}

