/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class SourceCoverageKvpParser
extends KvpParser {
    private Catalog catalog;

    public SourceCoverageKvpParser(Catalog catalog) {
        super("sourcecoverage", String.class);
        this.setService("wcs");
        this.catalog = catalog;
    }

    public Object parse(String value) throws Exception {
        ArrayList<String> coverages = new ArrayList<String>();
        List identifiers = KvpUtils.readFlat((String)value);
        if (identifiers == null || identifiers.size() == 0) {
            throw new WcsException("Required paramer, sourcecoverage, missing", WcsException.WcsExceptionCode.MissingParameterValue, "sourcecoverage");
        }
        for (String coverage : identifiers) {
            String coverageName = coverage.indexOf("@") > 0 ? coverage.substring(0, coverage.indexOf("@")) : coverage;
            String fieldName = coverage.indexOf("@") > 0 ? coverage.substring(coverage.indexOf("@") + 1) : null;
            LayerInfo layer = this.catalog.getLayerByName(value);
            if (layer == null || layer.getType() != LayerInfo.Type.RASTER) {
                throw new WcsException("Could not find sourcecoverage '" + coverage + "'", WcsException.WcsExceptionCode.InvalidParameterValue, "sourcecoverage");
            }
            coverages.add(coverage);
        }
        if (coverages.size() > 1) {
            throw new WcsException("Wrong parameter, sourcecoverage, more than one identifier was specified", WcsException.WcsExceptionCode.InvalidParameterValue, "sourcecoverage");
        }
        return coverages.get(0);
    }
}

