/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.Gml4wcsFactory;
import net.opengis.gml.PointType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.TimePositionType;
import net.opengis.gml.VectorType;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.DomainSubsetType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.OutputType;
import net.opengis.wcs10.RangeSubsetType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.TypedLiteralType;
import net.opengis.wcs10.Wcs10Factory;
import org.eclipse.emf.ecore.EFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.kvp.EMFKvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.vfny.geoserver.wcs.WcsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wcs10GetCoverageRequestReader
extends EMFKvpRequestReader {
    public static final String VERSION = "1.0.0";
    Catalog catalog;

    public Wcs10GetCoverageRequestReader(Catalog catalog) {
        super(GetCoverageType.class, (EFactory)Wcs10Factory.eINSTANCE);
        this.catalog = catalog;
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        String version;
        GetCoverageType getCoverage = (GetCoverageType)super.read(request, kvp, rawKvp);
        if (getCoverage.getSourceCoverage() == null) {
            if (kvp.get("coverage") == null) {
                throw new WcsException("source coverage parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "source coverage");
            }
            getCoverage.setSourceCoverage((String)((List)kvp.get("coverage")).get(0));
        }
        if (!getCoverage.isSetVersion()) {
            throw new WcsException("Version has not been specified", WcsException.WcsExceptionCode.MissingParameterValue, "version");
        }
        ArrayList<String> provided = new ArrayList<String>();
        provided.add(VERSION);
        ArrayList<String> accepted = null;
        if (getCoverage.getVersion() != null) {
            accepted = new ArrayList<String>();
            accepted.add(getCoverage.getVersion());
        }
        if (!VERSION.equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            throw new WcsException("An invalid version number has been specified", WcsException.WcsExceptionCode.InvalidParameterValue, "version");
        }
        getCoverage.setVersion(VERSION);
        getCoverage.setDomainSubset(this.parseDomainSubset(kvp));
        getCoverage.setRangeSubset(this.parseRangeSubset(kvp, getCoverage.getSourceCoverage()));
        getCoverage.setOutput(this.parseOutputElement(kvp));
        return getCoverage;
    }

    private DomainSubsetType parseDomainSubset(Map kvp) {
        DomainSubsetType domainSubset = Wcs10Factory.eINSTANCE.createDomainSubsetType();
        SpatialSubsetType spatialSubset = Wcs10Factory.eINSTANCE.createSpatialSubsetType();
        String crsName = (String)kvp.get("crs");
        if (crsName == null) {
            throw new WcsException("CRS parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "crs");
        }
        CoordinateReferenceSystem crs = Wcs10GetCoverageRequestReader.decodeCRS100(crsName);
        if (crs == null) {
            throw new WcsException("CRS parameter is invalid:" + crsName, WcsException.WcsExceptionCode.InvalidParameterValue, "crs");
        }
        GeneralEnvelope bbox = (GeneralEnvelope)kvp.get("BBOX");
        if (bbox == null) {
            throw new WcsException("bbox parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "bbox");
        }
        if (bbox.getDimension() != 2) {
            throw new WcsException("Requested bounding box is not 2-dimensional: " + bbox.getDimension(), WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        GeneralEnvelope envelope = new GeneralEnvelope((CoordinateReferenceSystem)(bbox.getDimension() == 3 ? DefaultGeographicCRS.WGS84_3D : crs));
        if (bbox.getDimension() != 2) {
            throw new WcsException("bbox not compliant with the specified CRS", WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        envelope.setEnvelope(new double[]{bbox.getLowerCorner().getOrdinate(0), bbox.getLowerCorner().getOrdinate(1), bbox.getUpperCorner().getOrdinate(0), bbox.getUpperCorner().getOrdinate(1)});
        TimeSequenceType timeSequence = null;
        Object time = kvp.get("TIME");
        if (time != null && time instanceof TimeSequenceType) {
            timeSequence = (TimeSequenceType)time;
        } else if (time != null && time instanceof List) {
            timeSequence = Wcs10Factory.eINSTANCE.createTimeSequenceType();
            for (Date tPos : (List)time) {
                TimePositionType timePosition = Gml4wcsFactory.eINSTANCE.createTimePositionType();
                timePosition.setValue((Object)tPos);
                timeSequence.getTimePosition().add((Object)timePosition);
            }
        }
        if (timeSequence != null || bbox == null) {
            // empty if block
        }
        RectifiedGridType grid = Gml4wcsFactory.eINSTANCE.createRectifiedGridType();
        Object w = kvp.get("width");
        Object h = kvp.get("height");
        if (w != null && h != null) {
            int width = w instanceof Integer ? (Integer)w : Integer.parseInt((String)w);
            int height = w instanceof Integer ? (Integer)h : Integer.parseInt((String)h);
            grid.getAxisName().add((Object)"x");
            grid.getAxisName().add((Object)"y");
            Object d = kvp.get("depth");
            if (d != null) {
                throw new WcsException("3D grids are not supported.", WcsException.WcsExceptionCode.InvalidParameterValue, "depth");
            }
            grid.setDimension(BigInteger.valueOf(2L));
            grid.setLimits((GridEnvelope)new GridEnvelope2D(0, 0, width, height));
        } else {
            Object rx = kvp.get("resx");
            Object ry = kvp.get("resy");
            if (rx != null && ry != null) {
                CoordinateSystem cs = crs.getCoordinateSystem();
                AxisDirection northingDirection = cs.getAxis(1).getDirection();
                int yAxisCorrection = AxisDirection.NORTH.equals((Object)northingDirection) ? -1 : 1;
                AxisDirection eastingDirection = cs.getAxis(0).getDirection();
                int xAxisCorrection = AxisDirection.EAST.equals((Object)eastingDirection) ? 1 : -1;
                double resX = Double.parseDouble((String)rx) * (double)xAxisCorrection;
                double resY = Double.parseDouble((String)ry) * (double)yAxisCorrection;
                double origX = envelope.getLowerCorner().getOrdinate(0) + resX / 2.0;
                double origY = envelope.getUpperCorner().getOrdinate(1) + resY / 2.0;
                PointType origin = Gml4wcsFactory.eINSTANCE.createPointType();
                DirectPositionType dp = Gml4wcsFactory.eINSTANCE.createDirectPositionType();
                origin.setPos(dp);
                origin.setSrsName(crsName);
                VectorType resolutionVector = Gml4wcsFactory.eINSTANCE.createVectorType();
                Object rz = kvp.get("resz");
                if (rz != null) {
                    throw new WcsException("3D grids are not supported.", WcsException.WcsExceptionCode.InvalidParameterValue, "resz");
                }
                grid.setDimension(BigInteger.valueOf(2L));
                dp.setDimension(grid.getDimension());
                dp.setValue(Arrays.asList(origX, origY));
                grid.setOrigin(origin);
                resolutionVector.setDimension(grid.getDimension());
                resolutionVector.setValue(Arrays.asList(resX, resY));
                grid.getOffsetVector().add((Object)resolutionVector);
            } else {
                throw new WcsException("Could not recognize grid resolution", WcsException.WcsExceptionCode.InvalidParameterValue, "");
            }
        }
        spatialSubset.getEnvelope().add((Object)envelope);
        spatialSubset.getGrid().add((Object)grid);
        domainSubset.setSpatialSubset(spatialSubset);
        domainSubset.setTemporalSubset(timeSequence);
        return domainSubset;
    }

    private RangeSubsetType parseRangeSubset(Map kvp, String coverageName) {
        Object axis;
        RangeSubsetType rangeSubset = Wcs10Factory.eINSTANCE.createRangeSubsetType();
        if (kvp.get("Band") != null) {
            axis = kvp.get("Band");
            if (axis instanceof AxisSubsetType) {
                rangeSubset.getAxisSubset().add(axis);
            } else {
                this.checkTypeAxisRange(rangeSubset, axis, "Band");
            }
        }
        if (kvp.get("ELEVATION") != null) {
            axis = kvp.get("ELEVATION");
            if (axis instanceof AxisSubsetType) {
                rangeSubset.getAxisSubset().add(axis);
            } else {
                this.checkTypeAxisRange(rangeSubset, axis, "ELEVATION");
            }
        }
        return rangeSubset;
    }

    private void checkTypeAxisRange(RangeSubsetType rangeSubset, Object axis, String axisName) {
        if (axis instanceof String) {
            String bands = (String)axis;
            if (bands.contains("/")) {
                List unparsed = KvpUtils.readFlat((String)bands, (KvpUtils.Tokenizer)new KvpUtils.Tokenizer("/"));
                IntervalType interval = Wcs10Factory.eINSTANCE.createIntervalType();
                TypedLiteralType min = Wcs10Factory.eINSTANCE.createTypedLiteralType();
                TypedLiteralType max = Wcs10Factory.eINSTANCE.createTypedLiteralType();
                TypedLiteralType res = Wcs10Factory.eINSTANCE.createTypedLiteralType();
                if (unparsed.size() == 2) {
                    min.setValue((String)unparsed.get(0));
                    max.setValue((String)unparsed.get(1));
                    interval.setMin(min);
                    interval.setMax(max);
                } else {
                    min.setValue((String)unparsed.get(0));
                    max.setValue((String)unparsed.get(1));
                    res.setValue((String)unparsed.get(2));
                    interval.setMin(min);
                    interval.setMax(max);
                    interval.setRes(res);
                }
                AxisSubsetType axisSubset = Wcs10Factory.eINSTANCE.createAxisSubsetType();
                axisSubset.setName(axisName);
                axisSubset.getInterval().add((Object)interval);
                rangeSubset.getAxisSubset().add((Object)axisSubset);
            } else {
                List unparsed = KvpUtils.readFlat((String)bands, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
                if (unparsed.size() == 0) {
                    throw new WcsException("Requested axis subset contains wrong number of values (should have at least 1): " + unparsed.size(), WcsException.WcsExceptionCode.InvalidParameterValue, "band");
                }
                AxisSubsetType axisSubset = Wcs10Factory.eINSTANCE.createAxisSubsetType();
                axisSubset.setName(axisName);
                for (String bandValue : unparsed) {
                    TypedLiteralType singleValue = Wcs10Factory.eINSTANCE.createTypedLiteralType();
                    singleValue.setValue(bandValue);
                    axisSubset.getSingleValue().add((Object)singleValue);
                }
                rangeSubset.getAxisSubset().add((Object)axisSubset);
            }
        } else if (axis instanceof Double || axis instanceof Integer) {
            AxisSubsetType axisSubset = Wcs10Factory.eINSTANCE.createAxisSubsetType();
            axisSubset.setName(axisName);
            TypedLiteralType singleValue = Wcs10Factory.eINSTANCE.createTypedLiteralType();
            singleValue.setValue(String.valueOf(axis));
            axisSubset.getSingleValue().add((Object)singleValue);
            rangeSubset.getAxisSubset().add((Object)axisSubset);
        }
    }

    private OutputType parseOutputElement(Map<String, String> kvp) throws Exception {
        OutputType output = Wcs10Factory.eINSTANCE.createOutputType();
        CodeType crsType = Gml4wcsFactory.eINSTANCE.createCodeType();
        CodeType formatType = Gml4wcsFactory.eINSTANCE.createCodeType();
        String format = kvp.get("format");
        if (format == null) {
            throw new WcsException("format parameter is mandatory", WcsException.WcsExceptionCode.MissingParameterValue, "format");
        }
        String crsName = kvp.get("response_crs") != null ? kvp.get("response_crs") : kvp.get("crs");
        CoordinateReferenceSystem crs = null;
        if (crsName != null) {
            crs = Wcs10GetCoverageRequestReader.decodeCRS100(crsName);
            crsType.setValue(CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
            output.setCrs(crsType);
        }
        formatType.setValue(format);
        output.setFormat(formatType);
        return output;
    }

    private static CoordinateReferenceSystem decodeCRS100(String crsName) throws WcsException {
        if ("WGS84(DD)".equals(crsName)) {
            crsName = "EPSG:4326";
        }
        try {
            return CRS.decode((String)crsName, (boolean)true);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new WcsException("Could not recognize crs " + crsName, WcsException.WcsExceptionCode.InvalidParameterValue, "crs");
        }
        catch (FactoryException e) {
            throw new WcsException("Could not recognize crs " + crsName, WcsException.WcsExceptionCode.InvalidParameterValue, "crs");
        }
    }
}

