/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wcs10.DescribeCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Wcs10DescribeCoverageTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)Wcs10DescribeCoverageTransformer.class.getPackage().getName());
    private static final String WCS_URI = "http://www.opengis.net/wcs";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Map<String, String> METHOD_NAME_MAP = new HashMap<String, String>();
    private WCSInfo wcs;
    private Catalog catalog;

    static {
        METHOD_NAME_MAP.put("nearest neighbor", "nearest");
        METHOD_NAME_MAP.put("bilinear", "linear");
        METHOD_NAME_MAP.put("bicubic", "cubic");
    }

    public Wcs10DescribeCoverageTransformer(WCSInfo wcs, Catalog catalog) {
        this.wcs = wcs;
        this.catalog = catalog;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS100DescribeCoverageTranslator(handler);
    }

    private class WCS100DescribeCoverageTranslator
    extends TransformerBase.TranslatorSupport {
        public static final String SCHEMAS = "schemas";
        private DescribeCoverageType request;
        private String proxifiedBaseUrl;

        public WCS100DescribeCoverageTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeCoverageType)) {
                throw new IllegalArgumentException("Not a GetCapabilitiesType: " + o);
            }
            this.request = (DescribeCoverageType)o;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", Wcs10DescribeCoverageTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = "xmlns:" + Wcs10DescribeCoverageTransformer.XSI_PREFIX;
            attributes.addAttribute("", prefixDef, prefixDef, "", Wcs10DescribeCoverageTransformer.XSI_URI);
            String locationAtt = Wcs10DescribeCoverageTransformer.XSI_PREFIX + ":schemaLocation";
            String locationDef = "http://www.opengis.net/wcs " + ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{SCHEMAS, "wcs/1.0.0/describeCoverage.xsd"}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "version", "version", "", "1.0.0");
            this.start("wcs:CoverageDescription", attributes);
            for (String coverageId : this.request.getCoverage()) {
                LayerInfo layer = Wcs10DescribeCoverageTransformer.this.catalog.getLayerByName(coverageId);
                if (layer == null || layer.getType() != LayerInfo.Type.RASTER) {
                    throw new WcsException("Could not find the specified coverage: " + coverageId, WcsException.WcsExceptionCode.InvalidParameterValue, "coverage");
                }
                CoverageInfo ci = Wcs10DescribeCoverageTransformer.this.catalog.getCoverageByName(coverageId);
                try {
                    this.handleCoverageOffering(ci);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error occurred during describe coverage xml encoding", e);
                }
            }
            this.end("wcs:CoverageDescription");
        }

        private void handleCoverageOffering(CoverageInfo ci) throws Exception {
            this.start("wcs:CoverageOffering");
            for (MetadataLinkInfo mdl : ci.getMetadataLinks()) {
                this.handleMetadataLink(mdl);
            }
            this.element("wcs:description", ci.getDescription());
            this.element("wcs:name", ci.getPrefixedName());
            this.element("wcs:label", ci.getTitle());
            this.handleLonLatEnvelope(ci, ci.getLatLonBoundingBox());
            this.handleKeywords(ci.getKeywords());
            this.handleDomain(ci);
            this.handleRange(ci);
            this.handleSupportedCRSs(ci);
            this.handleSupportedFormats(ci);
            this.handleSupportedInterpolations(ci);
            this.end("wcs:CoverageOffering");
        }

        private void handleMetadataLink(MetadataLinkInfo mdl) {
            if (mdl != null) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
                }
                if (attributes.getLength() > 0) {
                    this.element("wcs:metadataLink", mdl.getContent(), attributes);
                } else {
                    this.element("wcs:metadataLink", mdl.getContent());
                }
            }
        }

        private void handleLonLatEnvelope(CoverageInfo ci, ReferencedEnvelope referencedEnvelope) {
            CoverageStoreInfo csinfo = ci.getStore();
            if (csinfo == null) {
                throw new WcsException("Unable to acquire coverage store resource for coverage: " + ci.getName());
            }
            AbstractGridCoverage2DReader reader = null;
            try {
                reader = (AbstractGridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
            }
            catch (IOException e) {
                LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            if (reader == null) {
                throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            String[] metadataNames = reader.getMetadataNames();
            String timeMetadata = null;
            if (metadataNames != null && metadataNames.length > 0) {
                timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
            }
            if (referencedEnvelope != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "srsName", "srsName", "", "urn:ogc:def:crs:OGC:1.3:CRS84");
                this.start("wcs:lonLatEnvelope", attributes);
                StringBuilder minCP = new StringBuilder(Double.toString(referencedEnvelope.getMinX())).append(" ").append(referencedEnvelope.getMinY());
                StringBuilder maxCP = new StringBuilder(Double.toString(referencedEnvelope.getMaxX())).append(" ").append(referencedEnvelope.getMaxY());
                this.element("gml:pos", minCP.toString());
                this.element("gml:pos", maxCP.toString());
                if (timeMetadata != null && timeMetadata.length() > 0) {
                    String[] timePositions = timeMetadata.split(",");
                    this.element("gml:timePosition", timePositions[0]);
                    this.element("gml:timePosition", timePositions[timePositions.length - 1]);
                }
                this.end("wcs:lonLatEnvelope");
            }
        }

        private void handleKeywords(List kwords) {
            this.start("wcs:keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("wcs:keyword", it.next().toString());
                }
            }
            this.end("wcs:keywords");
        }

        private void handleDomain(CoverageInfo ci) throws Exception {
            String timeMetadata = null;
            Object elevationMetadata = null;
            CoverageStoreInfo csinfo = ci.getStore();
            if (csinfo == null) {
                throw new WcsException("Unable to acquire coverage store resource for coverage: " + ci.getName());
            }
            AbstractGridCoverage2DReader reader = null;
            try {
                reader = (AbstractGridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
            }
            catch (IOException e) {
                LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            if (reader == null) {
                throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            String[] metadataNames = reader.getMetadataNames();
            if (metadataNames != null && metadataNames.length > 0) {
                timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
            }
            this.start("wcs:domainSet");
            this.start("wcs:spatialDomain");
            this.handleBoundingBox(ci.getSRS(), ci.getNativeBoundingBox(), timeMetadata);
            this.handleGrid(ci);
            this.end("wcs:spatialDomain");
            if (timeMetadata != null && timeMetadata.length() > 0) {
                this.start("wcs:temporalDomain");
                this.handleTemporalDomain(ci, timeMetadata);
                this.end("wcs:temporalDomain");
            }
            this.end("wcs:domainSet");
        }

        private void handleBoundingBox(String srsName, ReferencedEnvelope referencedEnvelope, String timeMetadata) {
            if (referencedEnvelope != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "srsName", "srsName", "", srsName);
                StringBuilder minCP = new StringBuilder(Double.toString(referencedEnvelope.getMinX())).append(" ").append(referencedEnvelope.getMinY());
                StringBuilder maxCP = new StringBuilder(Double.toString(referencedEnvelope.getMaxX())).append(" ").append(referencedEnvelope.getMaxY());
                if (timeMetadata != null && timeMetadata.length() > 0) {
                    this.start("gml:EnvelopeWithTimePeriod", attributes);
                    this.element("gml:pos", minCP.toString());
                    this.element("gml:pos", maxCP.toString());
                    String[] timePositions = timeMetadata.split(",");
                    this.element("gml:timePosition", timePositions[0]);
                    this.element("gml:timePosition", timePositions[timePositions.length - 1]);
                    this.end("gml:EnvelopeWithTimePeriod");
                } else {
                    this.start("gml:Envelope", attributes);
                    this.element("gml:pos", minCP.toString());
                    this.element("gml:pos", maxCP.toString());
                    this.end("gml:Envelope");
                }
            }
        }

        private void handleTemporalDomain(CoverageInfo ci, String timeMetadata) {
            if (timeMetadata != null && timeMetadata.length() > 0) {
                String[] timePositions;
                String[] stringArray = timePositions = timeMetadata.split(",");
                int n = timePositions.length;
                int n2 = 0;
                while (n2 < n) {
                    String timePosition = stringArray[n2];
                    this.element("gml:timePosition", timePosition);
                    ++n2;
                }
            }
        }

        private void handleGrid(CoverageInfo ci) throws Exception {
            GridGeometry originalGrid = ci.getGrid();
            GridEnvelope gridRange = originalGrid.getGridRange();
            AffineTransform2D gridToCRS = (AffineTransform2D)originalGrid.getGridToCRS();
            int gridDimension = gridToCRS != null ? gridToCRS.getSourceDimensions() : 0;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "dimension", "dimension", "", String.valueOf(gridDimension));
            this.start("gml:RectifiedGrid", attributes);
            String lowers = "";
            String uppers = "";
            int r = 0;
            while (r < gridDimension) {
                if (gridToCRS.getSourceDimensions() > r) {
                    lowers = String.valueOf(lowers) + gridRange.getLow(r) + " ";
                    uppers = String.valueOf(uppers) + gridRange.getHigh(r) + " ";
                } else {
                    lowers = String.valueOf(lowers) + "0 ";
                    uppers = String.valueOf(uppers) + "0 ";
                }
                ++r;
            }
            this.start("gml:limits");
            this.start("gml:GridEnvelope");
            this.element("gml:low", lowers.trim());
            this.element("gml:high", uppers.trim());
            this.end("gml:GridEnvelope");
            this.end("gml:limits");
            int dn = 0;
            while (dn < ci.getCRS().getCoordinateSystem().getDimension()) {
                String axisName = ci.getCRS().getCoordinateSystem().getAxis(dn).getAbbreviation();
                axisName = axisName.toLowerCase().startsWith("lon") ? "x" : axisName;
                axisName = axisName.toLowerCase().startsWith("lat") ? "y" : axisName;
                this.element("gml:axisName", axisName);
                ++dn;
            }
            StringBuilder origins = new StringBuilder();
            origins.append(gridToCRS.getTranslateX()).append(" ").append(gridToCRS.getTranslateY());
            this.start("gml:origin");
            this.element("gml:pos", origins.toString());
            this.end("gml:origin");
            StringBuilder offsetX = new StringBuilder();
            offsetX.append(gridToCRS.getScaleX()).append(" ").append(gridToCRS.getShearX());
            this.element("gml:offsetVector", offsetX.toString());
            StringBuilder offsetY = new StringBuilder();
            offsetY.append(gridToCRS.getShearY()).append(" ").append(gridToCRS.getScaleY());
            this.element("gml:offsetVector", offsetY.toString());
            this.end("gml:RectifiedGrid");
        }

        private void handleRange(CoverageInfo ci) {
            this.start("wcs:rangeSet");
            this.start("wcs:RangeSet");
            this.element("wcs:name", ci.getName());
            this.element("wcs:label", ci.getTitle());
            this.start("wcs:axisDescription");
            this.start("wcs:AxisDescription");
            int numSampleDimensions = ci.getDimensions().size();
            this.element("wcs:name", "Band");
            this.element("wcs:label", "Band");
            this.start("wcs:values");
            if (numSampleDimensions > 1) {
                this.start("wcs:interval");
                this.element("wcs:min", "1");
                this.element("wcs:max", String.valueOf(numSampleDimensions));
                this.end("wcs:interval");
            } else {
                this.element("wcs:singleValue", "1");
            }
            this.end("wcs:values");
            this.end("wcs:AxisDescription");
            AbstractGridCoverage2DReader reader = null;
            try {
                reader = (AbstractGridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
            }
            catch (IOException e) {
                LOGGER.severe("Unable to acquire a reader for this coverage with format: " + ci.getStore().getFormat().getName());
            }
            if (reader == null) {
                throw new WcsException("Unable to acquire a reader for this coverage with format: " + ci.getStore().getFormat().getName());
            }
            String[] metadataNames = reader.getMetadataNames();
            String elevationMetadata = null;
            if (metadataNames != null && metadataNames.length > 0) {
                String[] values;
                elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
                this.start("wcs:AxisDescription");
                this.element("wcs:name", "ELEVATION");
                this.element("wcs:label", "ELEVATION");
                this.start("wcs:values");
                String[] stringArray = values = elevationMetadata.split(",");
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.element("wcs:singleValue", s);
                    ++n2;
                }
                this.element("wcs:default", values[0]);
                this.end("wcs:values");
                this.end("wcs:AxisDescription");
            }
            this.end("wcs:axisDescription");
            this.end("wcs:RangeSet");
            this.end("wcs:rangeSet");
        }

        private void handleSupportedCRSs(CoverageInfo ci) throws Exception {
            LinkedHashSet supportedCRSs = new LinkedHashSet();
            if (ci.getRequestSRS() != null) {
                supportedCRSs.addAll(ci.getRequestSRS());
            }
            if (ci.getResponseSRS() != null) {
                supportedCRSs.addAll(ci.getResponseSRS());
            }
            this.start("wcs:supportedCRSs");
            for (String crsName : supportedCRSs) {
                CoordinateReferenceSystem crs = CRS.decode((String)crsName, (boolean)true);
                this.element("wcs:requestResponseCRSs", CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false));
            }
            this.end("wcs:supportedCRSs");
        }

        private String urnIdentifier(CoordinateReferenceSystem crs) throws FactoryException {
            String authorityAndCode = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            String code = authorityAndCode.substring(authorityAndCode.lastIndexOf(":") + 1);
            return "urn:ogc:def:crs:EPSG::" + code;
        }

        private void handleSupportedFormats(CoverageInfo ci) throws Exception {
            String nativeFormat = ci.getNativeFormat() != null && ci.getNativeFormat().equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : ci.getNativeFormat();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "nativeFormat", "nativeFormat", "", nativeFormat);
            HashSet<String> formats = new HashSet<String>();
            for (String format : ci.getSupportedFormats()) {
                formats.add(format);
            }
            this.start("wcs:supportedFormats", attributes);
            ArrayList sortedFormats = new ArrayList(formats);
            Collections.sort(sortedFormats);
            for (String format : sortedFormats) {
                this.element("wcs:formats", format.equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : format);
            }
            this.end("wcs:supportedFormats");
        }

        private void handleSupportedInterpolations(CoverageInfo ci) {
            if (ci.getDefaultInterpolationMethod() != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "default", "default", "", ci.getDefaultInterpolationMethod());
                this.start("wcs:supportedInterpolations", attributes);
            } else {
                this.start("wcs:supportedInterpolations");
            }
            for (String method : ci.getInterpolationMethods()) {
                String converted = (String)METHOD_NAME_MAP.get(method);
                if (method == null) continue;
                this.element("wcs:interpolationMethod", method);
            }
            this.end("wcs:supportedInterpolations");
        }
    }
}

