/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.ArrayList;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescribeCoverageTest
extends WCSTestSupport {
    public void testDescribeAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        DescribeCoverageTest.assertEquals((int)count, (int)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
    }

    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageStoreInfo cvInfo = this.getCatalog().getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart());
        cvInfo.setURL("file:///I/AM/NOT/THERE");
        this.getCatalog().save((StoreInfo)cvInfo);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        DescribeCoverageTest.assertEquals((int)(count - 1), (int)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
    }

    public void testDescribeUnknownCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=plop");
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
        DescribeCoverageTest.assertEquals((String)"InvalidParameterValue", (String)element.getAttribute("code"));
        DescribeCoverageTest.assertEquals((String)"coverage", (String)element.getAttribute("locator"));
        DescribeCoverageTest.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    public void testDescribeMissingVersion() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
        DescribeCoverageTest.assertEquals((String)"MissingParameterValue", (String)element.getAttribute("code"));
        DescribeCoverageTest.assertEquals((String)"version", (String)element.getAttribute("locator"));
    }

    public void testDescribeUnknownCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>plop</wcs:Coverage>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
        DescribeCoverageTest.assertEquals((String)"InvalidParameterValue", (String)element.getAttribute("code"));
        DescribeCoverageTest.assertEquals((String)"coverage", (String)element.getAttribute("locator"));
        DescribeCoverageTest.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    public void testDescribeDemCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    public void testDescribeDemCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wcs:Coverage>\r\n" + "</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    private void checkDemCoverageDescription(Document dom) throws Exception {
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_DEM), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsLow.length);
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsHigh.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrsLow.length) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
            ++i;
        }
        i = 2;
        while (i < 2 + offsetStrsHigh.length) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[1]);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[2]);
        DescribeCoverageTest.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:AxisDescription").getLength());
    }

    public void testDescribeRotatedCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.ROTATED_CAD));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.ROTATED_CAD), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsLow.length);
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsHigh.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrsLow.length) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
            ++i;
        }
        i = 2;
        while (i < 2 + offsetStrsHigh.length) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[1] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[2] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertTrue((offsets[3] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:AxisDescription").getLength());
    }

    public void testDescribeImageCoverage() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_BM));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_BM), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsLow.length);
        DescribeCoverageTest.assertEquals((int)2, (int)offsetStrsHigh.length);
        double[] offsets = new double[4];
        int i = 0;
        while (i < offsetStrsLow.length) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
            ++i;
        }
        i = 2;
        while (i < 2 + offsetStrsHigh.length) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
            ++i;
        }
        DescribeCoverageTest.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[1]);
        DescribeCoverageTest.assertEquals((Object)0.0, (Object)offsets[2]);
        DescribeCoverageTest.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:AxisDescription").getLength());
        DescribeCoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("wcs:interval").getLength());
    }

    public void testWorksapceQualified() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + MockData.TASMANIA_DEM.getLocalPart() + "</wcs:Coverage>\r\n" + "</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("cdf/wcs", request);
        DescribeCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        dom = this.postAsDOM("wcs", request);
        DescribeCoverageTest.assertEquals((String)"wcs:CoverageDescription", (String)dom.getDocumentElement().getNodeName());
    }

    public void testLayerQualified() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + MockData.TASMANIA_DEM.getLocalPart() + "</wcs:Coverage>\r\n" + "</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs/World/wcs", request);
        DescribeCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
        dom = this.postAsDOM("wcs/DEM/wcs", request);
        DescribeCoverageTest.assertEquals((String)"wcs:CoverageDescription", (String)dom.getDocumentElement().getNodeName());
    }
}

