/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.util.List;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.TypedLiteralType;
import net.opengis.wcs10.Wcs10Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.vfny.geoserver.wcs.WcsException;

public class AxisSubsetKvpParser
extends KvpParser {
    public AxisSubsetKvpParser() {
        super("band", AxisSubsetType.class);
        this.setService("wcs");
    }

    public Object parse(String value) throws Exception {
        AxisSubsetType axisSubset = Wcs10Factory.eINSTANCE.createAxisSubsetType();
        axisSubset.setName("Band");
        if (value.contains("/")) {
            List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)new KvpUtils.Tokenizer("/"));
            IntervalType interval = Wcs10Factory.eINSTANCE.createIntervalType();
            TypedLiteralType min = Wcs10Factory.eINSTANCE.createTypedLiteralType();
            TypedLiteralType max = Wcs10Factory.eINSTANCE.createTypedLiteralType();
            TypedLiteralType res = Wcs10Factory.eINSTANCE.createTypedLiteralType();
            if (unparsed.size() == 2) {
                min.setValue((String)unparsed.get(0));
                max.setValue((String)unparsed.get(1));
                interval.setMin(min);
                interval.setMax(max);
            } else {
                min.setValue((String)unparsed.get(0));
                max.setValue((String)unparsed.get(1));
                res.setValue((String)unparsed.get(2));
                interval.setMin(min);
                interval.setMax(max);
                interval.setRes(res);
            }
            axisSubset.getInterval().add((Object)interval);
        } else {
            List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
            if (unparsed.size() == 0) {
                throw new WcsException("Requested axis subset contains wrong number of values (should have at least 1): " + unparsed.size(), WcsException.WcsExceptionCode.InvalidParameterValue, "band");
            }
            for (String bandValue : unparsed) {
                TypedLiteralType singleValue = Wcs10Factory.eINSTANCE.createTypedLiteralType();
                singleValue.setValue(bandValue);
                axisSubset.getSingleValue().add((Object)singleValue);
            }
        }
        return axisSubset;
    }
}

