/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import junit.framework.TestCase;
import net.opengis.ows11.BoundingBoxType;
import org.geoserver.wcs.kvp.BoundingBoxKvpParser;
import org.vfny.geoserver.wcs.WcsException;

public class BoundingBoxKvpParserTest
extends TestCase {
    BoundingBoxKvpParser parser = new BoundingBoxKvpParser();

    public void test1DRange() throws Exception {
        this.executeFailingBBoxTest("10", "This bbox was invalid?");
        this.executeFailingBBoxTest("10,20", "This bbox was invalid?");
        this.executeFailingBBoxTest("10,20,30", "This bbox was invalid?");
    }

    public void testNonNumericalRange() throws Exception {
        this.executeFailingBBoxTest("10,20,a,b", "This bbox was invalid?");
        this.executeFailingBBoxTest("a,20,30,b", "This bbox was invalid?");
    }

    public void testOutOfDimRange() throws Exception {
        this.executeFailingBBoxTest("10,20,30,40,50,60,EPSG:4326", "This bbox has more dimensions than the crs?");
        this.executeFailingBBoxTest("10,20,30,40,EPSG:4979", "This bbox has less dimensions than the crs?");
    }

    public void testUnknownCRS() throws Exception {
        this.executeFailingBBoxTest("10,20,30,40,50,60,EPSG:MakeNoPrisoners!", "This crs should definitely be unknown...");
    }

    void executeFailingBBoxTest(String bbox, String message) throws Exception {
        try {
            this.parser.parse(bbox);
            BoundingBoxKvpParserTest.fail((String)message);
        }
        catch (WcsException e) {
            BoundingBoxKvpParserTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            BoundingBoxKvpParserTest.assertEquals((String)"BoundingBox", (String)e.getLocator());
        }
    }

    public void testNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30");
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getLowerCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getUpperCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)15.0, bbox.getUpperCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)30.0, bbox.getUpperCorner().get(1));
        BoundingBoxKvpParserTest.assertNull((Object)bbox.getCrs());
    }

    public void test2DNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30,EPSG:4326");
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getLowerCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getUpperCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)15.0, bbox.getUpperCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)30.0, bbox.getUpperCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((String)"EPSG:4326", (String)bbox.getCrs());
    }

    public void test3DNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30,40,50,EPSG:4979");
        BoundingBoxKvpParserTest.assertEquals((int)3, (int)bbox.getLowerCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((Object)15.0, bbox.getLowerCorner().get(2));
        BoundingBoxKvpParserTest.assertEquals((int)3, (int)bbox.getUpperCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)30.0, bbox.getUpperCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)40.0, bbox.getUpperCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((Object)50.0, bbox.getUpperCorner().get(2));
        BoundingBoxKvpParserTest.assertEquals((String)"EPSG:4979", (String)bbox.getCrs());
    }

    public void testWgs84FullExtent() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("-180,-90,180,90,urn:ogc:def:crs:EPSG:4326");
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getLowerCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)-180.0, bbox.getLowerCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)-90.0, bbox.getLowerCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((int)2, (int)bbox.getUpperCorner().size());
        BoundingBoxKvpParserTest.assertEquals((Object)180.0, bbox.getUpperCorner().get(0));
        BoundingBoxKvpParserTest.assertEquals((Object)90.0, bbox.getUpperCorner().get(1));
        BoundingBoxKvpParserTest.assertEquals((String)"urn:ogc:def:crs:EPSG:4326", (String)bbox.getCrs());
    }
}

